/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.crypts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import me.saro.kit.bytes.Bytes;
import me.saro.kit.crypts.SimpleCryptImpl;

public interface SimpleCrypt {
    public static SimpleCrypt encrypt(String transformation, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, (Key)new SecretKeySpec(key, cipher.getAlgorithm().split("\\/")[0]), new IvParameterSpec(iv));
        return new SimpleCryptImpl(cipher);
    }

    public static SimpleCrypt decrypt(String transformation, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, (Key)new SecretKeySpec(key, cipher.getAlgorithm().split("\\/")[0]), new IvParameterSpec(iv));
        return new SimpleCryptImpl(cipher);
    }

    public void to(InputStream var1, OutputStream var2) throws IOException;

    public void to(File var1, File var2, boolean var3) throws IOException;

    public byte[] toBytes(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException;

    public byte[] toBytes(byte[] var1) throws IllegalBlockSizeException, BadPaddingException;

    default public byte[] toBytesByHex(String hex) throws IllegalBlockSizeException, BadPaddingException {
        return this.toBytes(Bytes.toBytesByHex(hex));
    }

    default public byte[] toBytesByBase64(String base64) throws IllegalBlockSizeException, BadPaddingException {
        return this.toBytes(Base64.getDecoder().decode(base64));
    }

    default public String toHex(byte[] data, int offset, int length) throws IllegalBlockSizeException, BadPaddingException {
        return Bytes.toHex(this.toBytes(data, offset, length));
    }

    default public String toHex(byte[] data) throws IllegalBlockSizeException, BadPaddingException {
        return Bytes.toHex(this.toBytes(data));
    }

    default public String toHexByHex(String hex) throws IllegalBlockSizeException, BadPaddingException {
        return Bytes.toHex(Bytes.toBytesByHex(hex));
    }

    default public String toHexByBase64(String base64) throws IllegalBlockSizeException, BadPaddingException {
        return Bytes.toHex(Base64.getDecoder().decode(base64));
    }

    default public String toBase64(byte[] data, int offset, int length) throws IllegalBlockSizeException, BadPaddingException {
        return Base64.getEncoder().encodeToString(this.toBytes(data, offset, length));
    }

    default public String toBase64(byte[] data) throws IllegalBlockSizeException, BadPaddingException {
        return Base64.getEncoder().encodeToString(this.toBytes(data));
    }

    default public String toBase64ByHex(String hex) throws IllegalBlockSizeException, BadPaddingException {
        return Base64.getEncoder().encodeToString(Bytes.toBytesByHex(hex));
    }

    default public String toBase64ByBase64(String base64) throws IllegalBlockSizeException, BadPaddingException {
        return Base64.getEncoder().encodeToString(Base64.getDecoder().decode(base64));
    }
}

