/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.bytes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class BytesWriter {
    private final Charset charset;
    private final ByteArrayOutputStream body;
    private byte fillByte = (byte)32;

    public BytesWriter() {
        this.body = new ByteArrayOutputStream();
        this.charset = Charset.forName("UTF-8");
    }

    public BytesWriter(int initSize, Charset charset) {
        this.body = new ByteArrayOutputStream(initSize);
        this.charset = charset;
    }

    public BytesWriter fillByte(byte fillByte) {
        this.fillByte = fillByte;
        return this;
    }

    public BytesWriter add(byte[] buf, int offset, int length) {
        this.body.write(buf, offset, length);
        return this;
    }

    public BytesWriter add(byte[] buf) {
        return this.add(buf, 0, buf.length);
    }

    public BytesWriter add(String text) {
        return this.add(text.getBytes(this.charset));
    }

    public BytesWriter add(String text, int fixedSize) {
        byte[] buf = text.getBytes(this.charset);
        int leftSize = fixedSize - buf.length;
        if (leftSize < 0) {
            throw new RuntimeException("[" + text + "] is out of fixed-size[" + fixedSize + "] position: " + this.body.size());
        }
        if (leftSize == 0) {
            return this.add(buf);
        }
        byte[] fill = new byte[leftSize];
        Arrays.fill(fill, this.fillByte);
        return this.add(buf).add(fill);
    }

    public BytesWriter add(int data, int fixedSize) {
        return this.add(Integer.toString(data), fixedSize);
    }

    public BytesWriter add(short data, int fixedSize) {
        return this.add(Short.toString(data), fixedSize);
    }

    public BytesWriter add(long data, int fixedSize) {
        return this.add(Long.toString(data), fixedSize);
    }

    public void bind(OutputStream os) {
        try {
            this.body.writeTo(os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toBytes() {
        return this.body.toByteArray();
    }

    public String toString() {
        try {
            return this.body.toString(this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

