/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.bytes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.IntStream;
import me.saro.kit.Texts;

public class Bytes {
    static final Base64.Encoder EN_BASE64 = Base64.getEncoder();
    static final Base64.Decoder DE_BASE64 = Base64.getDecoder();
    static final char[][] BYTE_TO_HEX_STR_MAP = (char[][])IntStream.range(0, 256).boxed().map(i -> String.format("%02x", i).toCharArray()).toArray(x$0 -> new char[x$0][]);

    private Bytes() {
    }

    public static String toHex(byte[] bytes) {
        StringBuilder rv = new StringBuilder(bytes.length * 2 + 10);
        for (byte b : bytes) {
            rv.append(BYTE_TO_HEX_STR_MAP[b & 0xFF]);
        }
        return rv.toString();
    }

    public static byte[] toBytesByHex(String hex) {
        byte[] rv = new byte[hex.length() / 2];
        int rvp = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            rv[rvp++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return rv;
    }

    public static String encodeBase64String(byte[] data) {
        return EN_BASE64.encodeToString(data);
    }

    public static String encodeBase64String(String text, String charset) {
        return EN_BASE64.encodeToString(Texts.getBytes(text, charset));
    }

    public static byte[] decodeBase64(String base64) {
        return DE_BASE64.decode(base64);
    }

    public static String decodeBase64(String base64, String charset) {
        return Bytes.toString(DE_BASE64.decode(base64), charset);
    }

    public static byte[] toBytes(short val) {
        return ByteBuffer.allocate(2).putShort(val).array();
    }

    public static byte[] toBytes(short[] val) {
        return Bytes.toBytes(val, 0, val.length);
    }

    public static byte[] toBytes(short[] val, int offset, int length) {
        ByteBuffer bb = ByteBuffer.allocate(2 * (length - offset));
        for (int i = offset; i < offset + length; ++i) {
            bb.putShort(val[i]);
        }
        return bb.array();
    }

    public static byte[] toBytes(int val) {
        return ByteBuffer.allocate(4).putInt(val).array();
    }

    public static byte[] toBytes(int[] val) {
        return Bytes.toBytes(val, 0, val.length);
    }

    public static byte[] toBytes(int[] val, int offset, int length) {
        ByteBuffer bb = ByteBuffer.allocate(4 * (length - offset));
        for (int i = offset; i < offset + length; ++i) {
            bb.putInt(val[i]);
        }
        return bb.array();
    }

    public static byte[] toBytes(long val) {
        return ByteBuffer.allocate(8).putLong(val).array();
    }

    public static byte[] toBytes(long[] val) {
        return Bytes.toBytes(val, 0, val.length);
    }

    public static byte[] toBytes(long[] val, int offset, int length) {
        ByteBuffer bb = ByteBuffer.allocate(8 * (length - offset));
        for (int i = offset; i < offset + length; ++i) {
            bb.putLong(val[i]);
        }
        return bb.array();
    }

    public static byte[] toBytes(float val) {
        return ByteBuffer.allocate(4).putFloat(val).array();
    }

    public static byte[] toBytes(float[] val) {
        return Bytes.toBytes(val, 0, val.length);
    }

    public static byte[] toBytes(float[] val, int offset, int length) {
        ByteBuffer bb = ByteBuffer.allocate(4 * (length - offset));
        for (int i = offset; i < offset + length; ++i) {
            bb.putFloat(val[i]);
        }
        return bb.array();
    }

    public static byte[] toBytes(double val) {
        return ByteBuffer.allocate(8).putDouble(val).array();
    }

    public static byte[] toBytes(double[] val) {
        return Bytes.toBytes(val, 0, val.length);
    }

    public static byte[] toBytes(double[] val, int offset, int length) {
        ByteBuffer bb = ByteBuffer.allocate(8 * (length - offset));
        for (int i = offset; i < offset + length; ++i) {
            bb.putDouble(val[i]);
        }
        return bb.array();
    }

    public static short toShort(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 2).getShort();
    }

    public static short[] toShortArray(byte[] bytes, int bytesOffset, int arrayLength) {
        short[] rv = new short[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            rv[i] = ByteBuffer.wrap(bytes, bytesOffset + 2 * i, 2).getShort();
        }
        return rv;
    }

    public static List<Short> toShortList(byte[] bytes, int bytesOffset, int arrayLength) {
        ArrayList<Short> rv = new ArrayList<Short>();
        for (int i = 0; i < arrayLength; ++i) {
            rv.add(ByteBuffer.wrap(bytes, bytesOffset + 2 * i, 2).getShort());
        }
        return rv;
    }

    public static short toShort(byte[] val) {
        return ByteBuffer.wrap(val, 0, 2).getShort();
    }

    public static int toInt(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 4).getInt();
    }

    public static int[] toIntArray(byte[] bytes, int bytesOffset, int arrayLength) {
        int[] rv = new int[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            rv[i] = ByteBuffer.wrap(bytes, bytesOffset + 4 * i, 4).getInt();
        }
        return rv;
    }

    public static List<Integer> toIntegerList(byte[] bytes, int bytesOffset, int arrayLength) {
        ArrayList<Integer> rv = new ArrayList<Integer>();
        for (int i = 0; i < arrayLength; ++i) {
            rv.add(ByteBuffer.wrap(bytes, bytesOffset + 4 * i, 4).getInt());
        }
        return rv;
    }

    public static int toInt(byte[] val) {
        return ByteBuffer.wrap(val, 0, 4).getInt();
    }

    public static long toLong(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 8).getLong();
    }

    public static long[] toLongArray(byte[] bytes, int bytesOffset, int arrayLength) {
        long[] rv = new long[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            rv[i] = ByteBuffer.wrap(bytes, bytesOffset + 8 * i, 8).getLong();
        }
        return rv;
    }

    public static List<Long> toLongList(byte[] bytes, int bytesOffset, int arrayLength) {
        ArrayList<Long> rv = new ArrayList<Long>();
        for (int i = 0; i < arrayLength; ++i) {
            rv.add(ByteBuffer.wrap(bytes, bytesOffset + 8 * i, 8).getLong());
        }
        return rv;
    }

    public static long toLong(byte[] val) {
        return ByteBuffer.wrap(val, 0, 8).getLong();
    }

    public static float toFloat(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 4).getFloat();
    }

    public static float[] toFloatArray(byte[] bytes, int bytesOffset, int arrayLength) {
        float[] rv = new float[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            rv[i] = ByteBuffer.wrap(bytes, bytesOffset + 4 * i, 4).getFloat();
        }
        return rv;
    }

    public static List<Float> toFloatList(byte[] bytes, int bytesOffset, int arrayLength) {
        ArrayList<Float> rv = new ArrayList<Float>();
        for (int i = 0; i < arrayLength; ++i) {
            rv.add(Float.valueOf(ByteBuffer.wrap(bytes, bytesOffset + 4 * i, 4).getFloat()));
        }
        return rv;
    }

    public static float toFloat(byte[] val) {
        return ByteBuffer.wrap(val, 0, 4).getFloat();
    }

    public static double toDouble(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 8).getDouble();
    }

    public static double[] toDoubleArray(byte[] bytes, int bytesOffset, int arrayLength) {
        double[] rv = new double[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            rv[i] = ByteBuffer.wrap(bytes, bytesOffset + 8 * i, 8).getDouble();
        }
        return rv;
    }

    public static List<Double> toDoubleList(byte[] bytes, int bytesOffset, int arrayLength) {
        ArrayList<Double> rv = new ArrayList<Double>();
        for (int i = 0; i < arrayLength; ++i) {
            rv.add(ByteBuffer.wrap(bytes, bytesOffset + 8 * i, 8).getDouble());
        }
        return rv;
    }

    public static double toDouble(byte[] val) {
        return ByteBuffer.wrap(val, 0, 8).getDouble();
    }

    public static byte[] copy(byte[] data, boolean reverse) {
        if (reverse) {
            return Bytes.reverse(Arrays.copyOf(data, data.length));
        }
        return Arrays.copyOf(data, data.length);
    }

    public static byte[] copy(byte[] data, int offset, int length, boolean reverse) {
        if (reverse) {
            return Bytes.reverse(Arrays.copyOfRange(data, offset, offset + length));
        }
        return Arrays.copyOfRange(data, offset, offset + length);
    }

    public static byte[] reverse(byte[] data, boolean reverse) {
        if (reverse) {
            return Bytes.reverse(data);
        }
        return data;
    }

    public static byte[] reverse(byte[] data, int offset, int length, boolean reverse) {
        if (reverse) {
            return Bytes.reverse(data, offset, length);
        }
        return data;
    }

    public static byte[] reverse(byte[] data) {
        return Bytes.reverse(data, 0, data.length);
    }

    public static byte[] reverse(byte[] data, int offset, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must much more then 0");
        }
        if (length == 1) {
            return data;
        }
        int move = length / 2;
        int i = 0;
        int s = offset;
        int e = length - 1;
        while (i < move) {
            byte t = data[s];
            data[s] = data[e];
            data[e] = t;
            ++i;
            ++s;
            --e;
        }
        return data;
    }

    public static byte parseByte(String value) {
        int iv = Integer.parseInt(value);
        if (iv > 255 || iv < -128) {
            throw new NumberFormatException("Value out of range. Value:\"" + value + "\" Radix:10");
        }
        return (byte)iv;
    }

    public static byte[] reverse(byte[] data, int offset, int length, int arrayLength) {
        if (arrayLength < 1) {
            throw new IllegalArgumentException("arrayLength must much more then 0");
        }
        for (int i = 0; i < arrayLength; ++i) {
            Bytes.reverse(data, offset + i * length, length);
        }
        return data;
    }

    public static String toString(byte[] b, String charset) {
        return Bytes.toString(b, charset);
    }

    public static String toString(byte[] b, int offset, int length, String charset) {
        return Bytes.toString(b, offset, length, charset);
    }
}

