/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import me.saro.kit.functions.ThrowableFunction;

public class Threads {
    public static <T, R> List<R> executeAllThreads(ExecutorService executorService, List<T> list, ThrowableFunction<T, R> map) {
        try {
            return executorService.invokeAll(list.parallelStream().map(e -> () -> map.apply(e)).collect(Collectors.toList())).parallelStream().map(ThrowableFunction.wrap(x -> x.get())).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static <T, R> List<R> executeAllThreads(int nThreads, List<T> list, ThrowableFunction<T, R> map) {
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        List<R> rv = Threads.executeAllThreads(executorService, list, map);
        executorService.shutdown();
        return rv;
    }

    public static void kill(Thread thread) {
        if (thread != null) {
            try {
                if (thread.isInterrupted()) {
                    thread.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

