/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class Texts {
    private static final char[] BASE62_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();

    public static List<String> split(String text, char token) {
        int i;
        char[] ca = text.toCharArray();
        int len = ca.length;
        int p = 0;
        ArrayList<String> rv = new ArrayList<String>();
        for (i = 0; i < len; ++i) {
            if (ca[i] != token) continue;
            rv.add(new String(ca, p, i - p));
            p = i + 1;
        }
        rv.add(new String(ca, p, i - p));
        return rv;
    }

    public static byte[] getBytes(String text, String charset) {
        return text.getBytes(Charset.forName(charset));
    }

    public static String next(String text, String token) {
        int s = text.indexOf(token);
        return s != -1 ? text.substring(s + token.length()) : "";
    }

    public static String lastNext(String text, String token) {
        int s = text.lastIndexOf(token);
        return s != -1 ? text.substring(s + token.length()) : "";
    }

    public static String prev(String text, String token) {
        int s = text.indexOf(token);
        return s != -1 ? text.substring(0, s) : "";
    }

    public static String lastPrev(String text, String token) {
        int s = text.lastIndexOf(token);
        return s != -1 ? text.substring(0, s) : "";
    }

    public static String gap(String text, String prefix, String suffix) {
        int s = text.indexOf(prefix);
        int e = text.indexOf(suffix, s + 1);
        return s != -1 && e != -1 ? text.substring(s + prefix.length(), e) : "";
    }

    public static String rtrim(String text, char spaceCharacter) {
        char[] ca = text.toCharArray();
        for (int i = ca.length - 1; i >= 0; --i) {
            if (ca[i] == spaceCharacter) continue;
            return new String(ca, 0, i + 1);
        }
        return "";
    }

    public static String ltrim(String text, char spaceCharacter) {
        char[] ca = text.toCharArray();
        int length = ca.length;
        for (int i = 0; i < length; ++i) {
            if (ca[i] == spaceCharacter) continue;
            return new String(ca, i, length - i);
        }
        return "";
    }

    @SafeVarargs
    public static String nvl(String ... datas) {
        for (String t : datas) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static String evl(String ... datas) {
        for (String val : datas) {
            if (val == null || val.isEmpty()) continue;
            return val;
        }
        return null;
    }

    public static String bvl(String ... datas) {
        for (String val : datas) {
            if (val == null || val.matches("[\\s]*")) continue;
            return val;
        }
        return null;
    }

    public static String createRandomString(char[] mold, int len) {
        char[] rv = new char[len];
        int charLen = mold.length;
        for (int i = 0; i < len; ++i) {
            rv[i] = mold[(int)(Math.random() * (double)charLen)];
        }
        return new String(rv);
    }

    public static String createRandomString(char[] mold, int min, int max) {
        return Texts.createRandomString(mold, (int)Texts.random(min, max));
    }

    public static String createRandomBase62String(int min, int max) {
        return Texts.createRandomString(BASE62_CHARS, (int)Texts.random(min, max));
    }

    public static long random(long min, long max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            throw new IllegalArgumentException("'lessThen' have to over the value then 'min'");
        }
        return min + (long)((int)(Math.random() * (double)(max + 1L - min)));
    }
}

