/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit;

import java.util.Arrays;

public class Numbers {
    public static String zerofill(String number, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must more then 1");
        }
        if (!number.matches("[\\d]+")) {
            throw new IllegalArgumentException("number must unsigned integer([0-9]+)");
        }
        int needFillSize = length - number.length();
        if (needFillSize == 0) {
            return number;
        }
        if (needFillSize > 0) {
            char[] fills = new char[needFillSize];
            Arrays.fill(fills, '0');
            return new String(fills) + number;
        }
        throw new IllegalArgumentException("[" + number + "] is over length then " + length);
    }

    public static String zerofill(long val, int length) {
        return Numbers.zerofill(Long.toString(val), length);
    }

    public static String zerofill(int val, int length) {
        return Numbers.zerofill(Integer.toString(val), length);
    }

    public static String norNumber(String number) {
        String no = number.trim().replace(",", "").replaceFirst("\\.[0]+", "");
        boolean m = false;
        switch (no.charAt(0)) {
            case '-': {
                m = true;
            }
            case '+': {
                no = no.substring(1);
            }
        }
        int zeroIndex = 0;
        for (char ch : no.toCharArray()) {
            if (ch != '0') break;
            ++zeroIndex;
        }
        return (m ? "-" : "") + (zeroIndex == 0 ? no : no.substring(zeroIndex));
    }

    public static double parseDouble(String doubleValue) {
        return Double.parseDouble(Numbers.norNumber(doubleValue));
    }

    public static long parseLong(String longValue) {
        return Long.parseLong(Numbers.norNumber(longValue));
    }
}

