/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.saro.kit.Streams;
import me.saro.kit.functions.ThrowableFunction;
import me.saro.kit.functions.ThrowablePredicate;

public class Files {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File createFile(File file, boolean overwrite, InputStream inputStream) throws Exception {
        if (file.exists()) {
            if (!overwrite) throw new IOException("create file error : already exists file : " + file.getAbsolutePath());
            file.delete();
        } else {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            } else if (parent.isFile()) {
                throw new IOException("create file error : file exists instend of the directory : " + parent.getAbsolutePath());
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             InputStream is = inputStream;){
            Streams.link(is, fos);
            return file;
        }
    }

    public static File createFile(File file, boolean overwrite, String value, String charset) throws Exception {
        return Files.createFile(file, overwrite, new ByteArrayInputStream(value.getBytes(charset)));
    }

    public static <R> R lines(File file, String charset, ThrowableFunction<Stream<String>, R> process) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            R r = Streams.lines(fis, charset, process);
            return r;
        }
    }

    public static List<File> list(File directory) {
        if (!directory.isDirectory()) {
            throw new RuntimeException(directory.getAbsolutePath() + " is not directory");
        }
        return Arrays.asList(directory.listFiles());
    }

    public static String toFilenameExtension(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        return pos != -1 ? name.substring(pos + 1) : "";
    }

    public static String toFilenameExtension(String filename) {
        return Files.toFilenameExtension(new File(filename));
    }

    public static boolean validFilenameExtension(File file, boolean ignoreCase, String ... filenameExtensions) {
        String extension = ignoreCase ? Files.toFilenameExtension(file).toLowerCase() : Files.toFilenameExtension(file);
        for (String filenameExtension : filenameExtensions) {
            if (!extension.equals(ignoreCase ? filenameExtension.toLowerCase() : filenameExtension)) continue;
            return true;
        }
        return false;
    }

    public static BasicFileAttributes toBasicFileAttributes(File file) throws IOException {
        return java.nio.file.Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
    }

    public static Predicate<File> attributesFilter(ThrowablePredicate<BasicFileAttributes> filter) {
        return ThrowablePredicate.wrap(e -> filter.test(Files.toBasicFileAttributes(e)));
    }
}

