/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CacheStore<ID, T> {
    private Map<ID, CacheWrapper<T>> store = new ConcurrentHashMap<ID, CacheWrapper<T>>();
    private final long cacheTimeMillis;

    public CacheStore(long cacheTimeMillis) {
        this.cacheTimeMillis = cacheTimeMillis;
    }

    public synchronized T get(ID id, Function<ID, T> orElse) {
        return (T)Optional.ofNullable(this.store.get(id)).map(CacheWrapper::get).orElseGet(() -> {
            Object data = orElse.apply(id);
            this.store.put(id, new CacheWrapper(this.cacheTimeMillis, data));
            return data;
        });
    }

    public T getAfterForcedUpdate(ID id, T value) {
        this.store.put(id, new CacheWrapper<T>(this.cacheTimeMillis, value));
        return value;
    }

    public void remove(ID id) {
        this.store.remove(id);
    }

    public void clear() {
        this.store.clear();
    }

    public static class CacheWrapper<T> {
        final long expireCacheTimeMillis;
        final T data;

        public CacheWrapper(long cacheTimeMillis, T data) {
            this.expireCacheTimeMillis = System.currentTimeMillis() + cacheTimeMillis;
            this.data = data;
        }

        public T get() {
            return this.expireCacheTimeMillis >= System.currentTimeMillis() ? (T)this.data : null;
        }
    }
}

