/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.ee.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.saro.kit.ee.ftp.Ftp;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;

public class Ftps
implements Ftp {
    final FTPClient ftp;

    public Ftps(FtpsOpener opener) throws IOException {
        FTPSClient ftp = null;
        try {
            ftp = opener.open();
        }
        catch (IOException e) {
            try {
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.ftp = ftp;
    }

    public Ftps(FtpOpener opener) throws IOException {
        FTPClient ftp = null;
        try {
            ftp = opener.open();
        }
        catch (IOException e) {
            try {
                if (ftp != null) {
                    ftp.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.ftp = ftp;
    }

    public void enterBinaryFileMode() throws IOException {
        this.ftp.setFileType(2);
    }

    public void enterAsciiFileMode() throws IOException {
        this.ftp.setFileType(0);
    }

    public void enterLocalPassiveMode() {
        this.ftp.enterLocalPassiveMode();
    }

    public void enterLocalActiveMode() {
        this.ftp.enterLocalActiveMode();
    }

    public void setUseEPSVwithIPv4(boolean selected) {
        this.ftp.setUseEPSVwithIPv4(selected);
    }

    @Override
    public boolean path(String pathname) throws IOException {
        return this.ftp.changeWorkingDirectory(pathname);
    }

    @Override
    public String path() throws IOException {
        return this.ftp.printWorkingDirectory();
    }

    @Override
    public boolean hasFile(String filename) throws IOException {
        FTPFile ff = this.ftp.mlistFile(filename);
        if (ff != null) {
            return ff.isFile();
        }
        return this.listFiles().parallelStream().anyMatch(e -> filename.equals(e));
    }

    @Override
    public boolean hasDirectory(String directoryName) throws IOException {
        FTPFile ff = this.ftp.mlistFile(this.path() + "/" + directoryName);
        if (ff != null) {
            return ff.isDirectory();
        }
        return this.listDirectories().parallelStream().anyMatch(e -> directoryName.equals(e));
    }

    @Override
    public List<String> listFiles(Predicate<String> filter) throws IOException {
        return Stream.of(this.ftp.listFiles()).filter(e -> e.isFile()).map(e -> e.getName()).filter(filter).collect(Collectors.toList());
    }

    @Override
    public List<String> listFiles() throws IOException {
        return Stream.of(this.ftp.listFiles()).filter(e -> e.isFile()).map(e -> e.getName()).collect(Collectors.toList());
    }

    @Override
    public List<String> listDirectories(Predicate<String> filter) throws IOException {
        return Stream.of(this.ftp.listFiles()).filter(e -> e.isDirectory()).map(e -> e.getName()).filter(filter).collect(Collectors.toList());
    }

    @Override
    public List<String> listDirectories() throws IOException {
        return Stream.of(this.ftp.listFiles()).filter(e -> e.isDirectory()).map(e -> e.getName()).collect(Collectors.toList());
    }

    @Override
    public boolean delete(String filename) throws IOException {
        if (this.hasFile(filename)) {
            return this.ftp.deleteFile(filename);
        }
        if (this.hasDirectory(filename)) {
            return this.ftp.removeDirectory(filename);
        }
        return false;
    }

    @Override
    public boolean send(String saveFilename, File localFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(localFile);){
            boolean bl = this.ftp.storeFile(saveFilename, (InputStream)fis);
            return bl;
        }
    }

    @Override
    public boolean recv(String remoteFilename, File localFile) throws IOException {
        if (this.hasFile(remoteFilename)) {
            if (localFile.exists()) {
                localFile.delete();
            }
            try (FileOutputStream fos = new FileOutputStream(localFile);){
                boolean bl = this.ftp.retrieveFile(remoteFilename, (OutputStream)fos);
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean mkdir(String createDirectoryName) throws IOException {
        this.ftp.mkd(createDirectoryName);
        return true;
    }

    @Override
    public void close() {
        try {
            this.ftp.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FTPClient getFTPClient() {
        return this.ftp;
    }

    public static interface FtpsOpener {
        public FTPSClient open() throws IOException;
    }

    public static interface FtpOpener {
        public FTPClient open() throws IOException;
    }
}

