/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.ee.ftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import me.saro.kit.ee.ftp.Ftps;
import me.saro.kit.ee.ftp.Sftp;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;

public interface Ftp
extends Closeable {
    public static Ftp ftp(Ftps.FtpOpener opener) throws IOException {
        return new Ftps(opener);
    }

    public static Ftp ftp(String host, int port, String user, String pass) throws IOException {
        return Ftp.ftp(() -> {
            FTPClient ftp = new FTPClient();
            ftp.setStrictReplyParsing(false);
            ftp.connect(host, port);
            ftp.enterLocalPassiveMode();
            ftp.setUseEPSVwithIPv4(false);
            if (!ftp.login(user, pass)) {
                throw new IOException("login fail");
            }
            ftp.setControlKeepAliveReplyTimeout(60000);
            ftp.setFileType(2);
            return ftp;
        });
    }

    public static Ftp ftp(String host, int port) throws IOException {
        return Ftp.ftp(host, port, "anonymous", "");
    }

    public static Ftp ftps(Ftps.FtpsOpener opener) throws IOException {
        return new Ftps(opener);
    }

    public static Ftp ftps(boolean isImplicit, String host, int port, String user, String pass) throws IOException {
        return Ftp.ftps(() -> {
            FTPSClient ftps = new FTPSClient(isImplicit);
            ftps.setStrictReplyParsing(false);
            ftps.connect(host, port);
            ftps.execPBSZ(0L);
            ftps.execPROT("P");
            ftps.enterLocalPassiveMode();
            ftps.setUseEPSVwithIPv4(false);
            if (!ftps.login(user, pass)) {
                throw new IOException("login fail");
            }
            ftps.setControlKeepAliveReplyTimeout(60000);
            ftps.setFileType(2);
            return ftps;
        });
    }

    public static Ftp ftps(boolean isImplicit, String host, int port) throws IOException {
        return Ftp.ftps(isImplicit, host, port, "anonymous", "");
    }

    public static Ftp sftp(String host, int port, String user, Sftp.SftpOpener opener) throws IOException {
        return new Sftp(host, port, user, opener);
    }

    public static Ftp sftp(String host, int port, String user, String pass) throws IOException {
        return Ftp.sftp(host, port, user, (Session session) -> {
            session.setPassword(pass);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            ChannelSftp sftp = (ChannelSftp)session.openChannel("sftp");
            sftp.connect();
            return sftp;
        });
    }

    public static Ftp sftp(String host, int port) throws IOException {
        return Ftp.sftp(host, port, "anonymous", "");
    }

    default public boolean cd(String pathname) throws IOException {
        return this.path(pathname);
    }

    public boolean path(String var1) throws IOException;

    public String path() throws IOException;

    default public String pwd() throws IOException {
        return this.path();
    }

    public List<String> listFiles(Predicate<String> var1) throws IOException;

    public List<String> listFiles() throws IOException;

    public List<String> listDirectories(Predicate<String> var1) throws IOException;

    public List<String> listDirectories() throws IOException;

    public boolean hasFile(String var1) throws IOException;

    public boolean hasDirectory(String var1) throws IOException;

    public boolean delete(String var1) throws IOException;

    public boolean send(String var1, File var2) throws IOException;

    default public boolean send(File localFile) throws IOException {
        return this.send(localFile.getName(), localFile);
    }

    public boolean recv(String var1, File var2) throws IOException;

    default public void recv(List<String> remoteFilenameList, File localDirectory) throws IOException {
        if (!localDirectory.isDirectory()) {
            throw new IOException("[" + localDirectory.getAbsolutePath() + "] is not Directory");
        }
        for (String file : remoteFilenameList) {
            if (this.recv(file, new File(localDirectory, file))) continue;
            throw new IOException("fail recv file [" + this.path() + "/" + file + "]");
        }
    }

    public boolean mkdir(String var1) throws IOException;

    @Override
    public void close();
}

