/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.ee.ftp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.function.Predicate;
import me.saro.kit.ee.ftp.Ftps;
import me.saro.kit.ee.ftp.Sftp;

public interface Ftp
extends Closeable {
    public static Ftp ftp(String host, int port, String user, String pass) throws IOException {
        return new Ftps(InetAddress.getByName(host), port, user, pass, false);
    }

    public static Ftp ftp(String host, int port) throws IOException {
        return new Ftps(InetAddress.getByName(host), port, "anonymous", "", false);
    }

    public static Ftp ftps(String host, int port, String user, String pass) throws IOException {
        return new Ftps(InetAddress.getByName(host), port, user, pass, true);
    }

    public static Ftp ftps(String host, int port) throws IOException {
        return new Ftps(InetAddress.getByName(host), port, "anonymous", "", true);
    }

    public static Ftp sftp(String host, int port, String user, String pass) throws IOException {
        return new Sftp(host, port, user, pass);
    }

    public static Ftp sftp(String host, int port) throws IOException {
        return new Sftp(host, port, "anonymous", "");
    }

    default public boolean cd(String pathname) throws IOException {
        return this.path(pathname);
    }

    public boolean path(String var1) throws IOException;

    public String path() throws IOException;

    default public String pwd() throws IOException {
        return this.path();
    }

    public List<String> listFiles(Predicate<String> var1) throws IOException;

    public List<String> listFiles() throws IOException;

    public List<String> listDirectories(Predicate<String> var1) throws IOException;

    public List<String> listDirectories() throws IOException;

    public boolean hasFile(String var1) throws IOException;

    public boolean hasDirectory(String var1) throws IOException;

    public boolean delete(String var1) throws IOException;

    public boolean send(String var1, File var2) throws IOException;

    default public boolean send(File localFile) throws IOException {
        return this.send(localFile.getName(), localFile);
    }

    public boolean recv(String var1, File var2) throws IOException;

    default public void recv(List<String> remoteFilenameList, File localDirectory) throws IOException {
        if (!localDirectory.isDirectory()) {
            throw new IOException("[" + localDirectory.getAbsolutePath() + "] is not Directory");
        }
        for (String file : remoteFilenameList) {
            if (this.recv(file, new File(localDirectory, file))) continue;
            throw new IOException("fail recv file [" + this.path() + "/" + file + "]");
        }
    }

    public boolean mkdir(String var1) throws IOException;

    @Override
    public void close();
}

