/*
 * Decompiled with CFR 0.152.
 */
package me.saro.kit.ee.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.saro.kit.Files;
import me.saro.kit.functions.ThrowableConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel {
    public static void open(File file, ThrowableConsumer<Workbook> callback) throws Exception {
        switch (Files.toFilenameExtension((File)file).toLowerCase()) {
            case "xlsx": {
                try (XSSFWorkbook book = new XSSFWorkbook(file);){
                    callback.accept((Object)book);
                    break;
                }
            }
            case "xls": {
                System.out.println(1);
                try (Workbook book = WorkbookFactory.create((InputStream)new FileInputStream(file));){
                    System.out.println(2);
                    callback.accept((Object)book);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("this lib support by .xls or .xlsx");
            }
        }
    }

    public static void rowStream(File file, int sheetIndex, ThrowableConsumer<Stream<Row>> callback) throws Exception {
        Excel.open(file, (ThrowableConsumer<Workbook>)((ThrowableConsumer)book -> callback.accept(StreamSupport.stream(Spliterators.spliteratorUnknownSize(book.getSheetAt(sheetIndex).rowIterator(), 16), false))));
    }

    public static double toDouble(Cell cell, double defaultValue) {
        try {
            return Excel.toDouble(cell);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double toDouble(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue() ? 1.0 : 0.0;
                }
                case NUMERIC: {
                    return cell.getNumericCellValue();
                }
                case FORMULA: {
                    String tmp = cell.getCellFormula();
                    if (tmp != null && !tmp.isEmpty()) {
                        return Double.parseDouble(tmp);
                    }
                }
                case STRING: {
                    String tmp = cell.getStringCellValue();
                    if (tmp == null || tmp.isEmpty()) break;
                    return Double.parseDouble(tmp);
                }
            }
        }
        throw new IllegalArgumentException(cell + " is not number");
    }

    public static Date toDate(Cell cell, Date defaultValue) {
        if (cell.getCellType() == CellType.STRING) {
            try {
                return cell.getDateCellValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String toString(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue() ? "1" : "0";
                }
                case FORMULA: {
                    return cell.getCellFormula();
                }
                case NUMERIC: {
                    return Double.toString(cell.getNumericCellValue());
                }
                case STRING: {
                    return cell.getStringCellValue();
                }
            }
        }
        return "";
    }
}

