/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.saro.jwt.core.JwtClaims;
import me.saro.jwt.core.JwtHeader;
import me.saro.jwt.core.JwtUtils;
import me.saro.jwt.exception.JwtException;
import me.saro.jwt.exception.JwtExceptionCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lme/saro/jwt/core/JwtUtils;", "", "()V", "Companion", "jwt"})
public final class JwtUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @NotNull
    private static final Base64.Decoder DE_BASE64_URL;
    @NotNull
    private static final Companion.TYPE_MAP.1 TYPE_MAP;
    @NotNull
    private static final Base64.Decoder DE_BASE64;
    @NotNull
    private static final Base64.Encoder EN_BASE64_URL_WOP;

    @JvmStatic
    @NotNull
    public static final String toJsonString(@NotNull Object obj) {
        return Companion.toJsonString(obj);
    }

    @JvmStatic
    @NotNull
    public static final byte[] decodeBase64(@NotNull String src) {
        return Companion.decodeBase64(src);
    }

    @JvmStatic
    @NotNull
    public static final byte[] decodeBase64Url(@NotNull String src) {
        return Companion.decodeBase64Url(src);
    }

    @JvmStatic
    @NotNull
    public static final String encodeToBase64UrlWopString(@NotNull byte[] src) {
        return Companion.encodeToBase64UrlWopString(src);
    }

    @JvmStatic
    @NotNull
    public static final String toJwtData(@NotNull Map<String, ? extends Object> header, @NotNull Map<String, ? extends Object> claims) {
        return Companion.toJwtData(header, claims);
    }

    @JvmStatic
    @NotNull
    public static final JwtHeader toJwtHeader(@Nullable String jwt) throws JwtException {
        return Companion.toJwtHeader(jwt);
    }

    @JvmStatic
    @NotNull
    public static final JwtClaims toJwtClaimsWithoutVerify(@Nullable String jwt) throws JwtException {
        return Companion.toJwtClaimsWithoutVerify(jwt);
    }

    static {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)decoder, (String)"getUrlDecoder()");
        DE_BASE64_URL = decoder;
        TYPE_MAP = new TypeReference<Map<String, Object>>(){};
        Base64.Decoder decoder2 = Base64.getDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)decoder2, (String)"getDecoder()");
        DE_BASE64 = decoder2;
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"getUrlEncoder().withoutPadding()");
        EN_BASE64_URL_WOP = encoder;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002*\u0001\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0001H\u0007J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007J0\u0010\u0018\u001a\u00020\u00102\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u001aH\u0007J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0017"}, d2={"Lme/saro/jwt/core/JwtUtils$Companion;", "", "()V", "DE_BASE64", "Ljava/util/Base64$Decoder;", "DE_BASE64_URL", "EN_BASE64_URL_WOP", "Ljava/util/Base64$Encoder;", "OBJECT_MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "TYPE_MAP", "me/saro/jwt/core/JwtUtils$Companion$TYPE_MAP$1", "Lme/saro/jwt/core/JwtUtils$Companion$TYPE_MAP$1;", "decodeBase64", "", "src", "", "decodeBase64Url", "encodeToBase64UrlWopString", "toJsonString", "obj", "toJwtClaimsWithoutVerify", "Lme/saro/jwt/core/JwtClaims;", "jwt", "toJwtData", "header", "", "claims", "toJwtHeader", "Lme/saro/jwt/core/JwtHeader;"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String toJsonString(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            String string = OBJECT_MAPPER.writeValueAsString(obj);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OBJECT_MAPPER.writeValueAsString(obj)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final byte[] decodeBase64(@NotNull String src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            byte[] byArray = DE_BASE64.decode(src);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"DE_BASE64.decode(src)");
            return byArray;
        }

        @JvmStatic
        @NotNull
        public final byte[] decodeBase64Url(@NotNull String src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            byte[] byArray = DE_BASE64_URL.decode(src);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"DE_BASE64_URL.decode(src)");
            return byArray;
        }

        @JvmStatic
        @NotNull
        public final String encodeToBase64UrlWopString(@NotNull byte[] src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            String string = EN_BASE64_URL_WOP.encodeToString(src);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EN_BASE64_URL_WOP.encodeToString(src)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String toJwtData(@NotNull Map<String, ? extends Object> header, @NotNull Map<String, ? extends Object> claims) {
            Intrinsics.checkNotNullParameter(header, (String)"header");
            Intrinsics.checkNotNullParameter(claims, (String)"claims");
            StringBuilder stringBuilder = new StringBuilder(200);
            byte[] byArray = OBJECT_MAPPER.writeValueAsBytes(header);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"OBJECT_MAPPER.writeValueAsBytes(header)");
            StringBuilder stringBuilder2 = stringBuilder.append(this.encodeToBase64UrlWopString(byArray)).append('.');
            byte[] byArray2 = OBJECT_MAPPER.writeValueAsBytes(claims);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"OBJECT_MAPPER.writeValueAsBytes(claims)");
            String string = stringBuilder2.append(this.encodeToBase64UrlWopString(byArray2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(200)\n     \u2026              .toString()");
            return string;
        }

        @JvmStatic
        @NotNull
        public final JwtHeader toJwtHeader(@Nullable String jwt) throws JwtException {
            JwtHeader jwtHeader;
            try {
                ObjectMapper objectMapper = OBJECT_MAPPER;
                Base64.Decoder decoder = DE_BASE64_URL;
                String string = jwt;
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.substring(0, StringsKt.indexOf$default((CharSequence)jwt, (char)'.', (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Object object = objectMapper.readValue(decoder.decode(string2), (TypeReference)TYPE_MAP);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OBJECT_MAPPER.readValue(\u2026indexOf('.'))), TYPE_MAP)");
                jwtHeader = new JwtHeader((Map)object);
            }
            catch (Exception e) {
                throw new JwtException(JwtExceptionCode.PARSE_ERROR, null, 2, null);
            }
            return jwtHeader;
        }

        @JvmStatic
        @NotNull
        public final JwtClaims toJwtClaimsWithoutVerify(@Nullable String jwt) throws JwtException {
            JwtClaims jwtClaims;
            try {
                ObjectMapper objectMapper = OBJECT_MAPPER;
                Base64.Decoder decoder = DE_BASE64_URL;
                String string = jwt;
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.substring(StringsKt.indexOf$default((CharSequence)jwt, (char)'.', (int)0, (boolean)false, (int)6, null) + 1, StringsKt.lastIndexOf$default((CharSequence)jwt, (char)'.', (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                Object object = objectMapper.readValue(decoder.decode(string2), (TypeReference)TYPE_MAP);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OBJECT_MAPPER.readValue(\u2026IndexOf('.'))), TYPE_MAP)");
                jwtClaims = new JwtClaims((Map)object);
            }
            catch (Exception e) {
                throw new JwtException(JwtExceptionCode.PARSE_ERROR, null, 2, null);
            }
            return jwtClaims;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

