/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.core;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.saro.jwt.core.JwtUtils;
import me.saro.jwt.exception.JwtException;
import me.saro.jwt.exception.JwtExceptionCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0004J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0012J\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u0015"}, d2={"Lme/saro/jwt/core/JwtHeader;", "", "header", "", "", "(Ljava/util/Map;)V", "algorithm", "getAlgorithm", "()Ljava/lang/String;", "kid", "getKid", "type", "getType", "assertAlgorithm", "", "get", "key", "toMap", "", "toString", "Companion", "jwt"})
public final class JwtHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> header;

    public JwtHeader(@NotNull Map<String, ? extends Object> header) {
        Intrinsics.checkNotNullParameter(header, (String)"header");
        this.header = header;
    }

    @Nullable
    public final String getKid() {
        return (String)this.get("kid");
    }

    @Nullable
    public final String getType() {
        return (String)this.get("typ");
    }

    @Nullable
    public final String getAlgorithm() {
        return (String)this.get("alg");
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.header.get(key);
    }

    @NotNull
    public final Map<String, Object> toMap() {
        return MapsKt.toMutableMap(this.header);
    }

    @NotNull
    public String toString() {
        return JwtUtils.Companion.toJsonString(this.header);
    }

    public final void assertAlgorithm(@NotNull String algorithm) throws JwtException {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        if (!Intrinsics.areEqual((Object)this.getAlgorithm(), (Object)algorithm)) {
            throw new JwtException(JwtExceptionCode.NOT_EQUALS_HEADER_ALGORITHM, null, 2, null);
        }
    }

    @JvmStatic
    @NotNull
    public static final JwtHeader create(@NotNull String algorithm) {
        return Companion.create(algorithm);
    }

    @JvmStatic
    @NotNull
    public static final JwtHeader create(@NotNull String algorithm, @NotNull Object kid) {
        return Companion.create(algorithm, kid);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0007\u00a8\u0006\b"}, d2={"Lme/saro/jwt/core/JwtHeader$Companion;", "", "()V", "create", "Lme/saro/jwt/core/JwtHeader;", "algorithm", "", "kid", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JwtHeader create(@NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"typ", (Object)"JWT"), TuplesKt.to((Object)"alg", (Object)algorithm)};
            return new JwtHeader(MapsKt.mapOf((Pair[])pairArray));
        }

        @JvmStatic
        @NotNull
        public final JwtHeader create(@NotNull String algorithm, @NotNull Object kid) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"typ", (Object)"JWT"), TuplesKt.to((Object)"alg", (Object)algorithm), TuplesKt.to((Object)"kid", (Object)kid)};
            return new JwtHeader(MapsKt.mapOf((Pair[])pairArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

