/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.core;

import java.time.OffsetDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.saro.jwt.core.JwtUtils;
import me.saro.jwt.exception.JwtException;
import me.saro.jwt.exception.JwtExceptionCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0001J\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001bJ\b\u0010\u001c\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/saro/jwt/core/JwtClaims;", "", "claims", "", "", "(Ljava/util/Map;)V", "assert", "", "assertExpire", "assertNotBefore", "audience", "value", "claim", "key", "claimLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "expire", "Ljava/util/Date;", "date", "Ljava/time/OffsetDateTime;", "id", "issuedAt", "issuer", "notBefore", "subject", "toMap", "", "toString", "Companion", "jwt"})
public final class JwtClaims {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> claims;

    public JwtClaims(@NotNull Map<String, Object> claims) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        this.claims = claims;
    }

    @NotNull
    public final JwtClaims claim(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.claims.put(key, value);
        return this;
    }

    @Nullable
    public final Object claim(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.claims.get(key);
    }

    @Nullable
    public final Long claimLong(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.claims.get(key);
        if (object == null) {
            return null;
        }
        Object v = object;
        Object object2 = v;
        return object2 instanceof Integer ? Long.valueOf(((Number)v).intValue()) : (object2 instanceof Long ? (Long)v : (object2 instanceof String ? Long.valueOf(Long.parseLong((String)v)) : Long.valueOf(Long.parseLong(v.toString()))));
    }

    @Nullable
    public final Object issuer() {
        return this.claim("iss");
    }

    @NotNull
    public final JwtClaims issuer(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim("iss", value);
    }

    @Nullable
    public final String subject() {
        return (String)this.claim("sub");
    }

    @NotNull
    public final JwtClaims subject(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim("sub", value);
    }

    @Nullable
    public final String audience() {
        return (String)this.claim("aud");
    }

    @NotNull
    public final JwtClaims audience(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim("aud", value);
    }

    @Nullable
    public final String id() {
        return (String)this.claim("jti");
    }

    @NotNull
    public final JwtClaims id(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim("jti", value);
    }

    @Nullable
    public final Date notBefore() {
        Date date;
        Long l = this.claimLong("nbf");
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            date = new Date(1000L * it);
        } else {
            date = null;
        }
        return date;
    }

    @NotNull
    public final JwtClaims notBefore(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.claim("nbf", date.getTime() / 1000L);
    }

    @NotNull
    public final JwtClaims notBefore(@NotNull OffsetDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.claim("nbf", date.toEpochSecond());
    }

    @Nullable
    public final Date issuedAt() {
        Date date;
        Long l = this.claimLong("iat");
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            date = new Date(1000L * it);
        } else {
            date = null;
        }
        return date;
    }

    @NotNull
    public final JwtClaims issuedAt(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.claim("iat", date.getTime() / 1000L);
    }

    @NotNull
    public final JwtClaims issuedAt(@NotNull OffsetDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.claim("iat", date.toEpochSecond());
    }

    @Nullable
    public final Date expire() {
        Date date;
        Long l = this.claimLong("exp");
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            date = new Date(1000L * it);
        } else {
            date = null;
        }
        return date;
    }

    @NotNull
    public final JwtClaims expire(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.claim("exp", date.getTime() / 1000L);
    }

    @NotNull
    public final JwtClaims expire(@NotNull OffsetDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.claim("exp", date.toEpochSecond());
    }

    @NotNull
    public String toString() {
        return JwtUtils.Companion.toJsonString(this.claims);
    }

    @NotNull
    public final Map<String, Object> toMap() {
        return MapsKt.toMutableMap(this.claims);
    }

    public final void assertExpire() throws JwtException {
        if (this.expire() != null) {
            Date date = this.expire();
            Intrinsics.checkNotNull((Object)date);
            if (date.before(new Date())) {
                throw new JwtException(JwtExceptionCode.DATE_EXPIRED, null, 2, null);
            }
        }
    }

    public final void assertNotBefore() throws JwtException {
        if (this.notBefore() != null) {
            Date date = this.notBefore();
            Intrinsics.checkNotNull((Object)date);
            if (date.after(new Date())) {
                throw new JwtException(JwtExceptionCode.DATE_EXPIRED, null, 2, null);
            }
        }
    }

    public final void assert() {
        this.assertExpire();
        this.assertNotBefore();
    }

    @JvmStatic
    @NotNull
    public static final JwtClaims create() {
        return Companion.create();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lme/saro/jwt/core/JwtClaims$Companion;", "", "()V", "create", "Lme/saro/jwt/core/JwtClaims;", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JwtClaims create() {
            return new JwtClaims(new LinkedHashMap());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

