/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.core;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import me.saro.jwt.core.JwtClaims;
import me.saro.jwt.core.JwtHeader;
import me.saro.jwt.core.JwtKey;
import me.saro.jwt.core.JwtUtils;
import me.saro.jwt.exception.JwtException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0007H&J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J,\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0005H\u0016J\u001a\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0007H&J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\u0013\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003H&\u00a8\u0006\u0011"}, d2={"Lme/saro/jwt/core/JwtAlgorithm;", "", "algorithm", "", "defaultHeader", "", "newRandomJwtKey", "Lme/saro/jwt/core/JwtKey;", "signature", "body", "key", "toJwt", "claims", "Lme/saro/jwt/core/JwtClaims;", "kid", "appendHeader", "toJwtClaims", "jwt", "toJwtClaimsOrNull", "toJwtClaimsWithoutVerify", "toJwtHeader", "Lme/saro/jwt/core/JwtHeader;", "toJwtKey"})
public interface JwtAlgorithm {
    @NotNull
    public String algorithm();

    @NotNull
    public JwtKey newRandomJwtKey();

    @NotNull
    public String signature(@NotNull String var1, @NotNull JwtKey var2) throws JwtException;

    @NotNull
    public JwtKey toJwtKey(@NotNull String var1) throws JwtException;

    @NotNull
    public Map<String, Object> defaultHeader();

    @NotNull
    public JwtHeader toJwtHeader(@Nullable String var1) throws JwtException;

    @NotNull
    public String toJwt(@NotNull JwtKey var1, @NotNull JwtClaims var2) throws JwtException;

    @NotNull
    public String toJwt(@NotNull JwtKey var1, @NotNull JwtClaims var2, @NotNull String var3) throws JwtException;

    @NotNull
    public String toJwt(@NotNull JwtKey var1, @NotNull JwtClaims var2, @NotNull Map<String, ? extends Object> var3) throws JwtException;

    @NotNull
    public JwtClaims toJwtClaimsWithoutVerify(@Nullable String var1) throws JwtException;

    @Nullable
    public JwtClaims toJwtClaimsOrNull(@NotNull String var1, @NotNull JwtKey var2);

    @NotNull
    public JwtClaims toJwtClaims(@NotNull String var1, @Nullable JwtKey var2) throws JwtException;

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Map<String, Object> defaultHeader(@NotNull JwtAlgorithm this_) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"TYP", (Object)"JWT"), TuplesKt.to((Object)"alg", (Object)this_.algorithm())};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public static JwtHeader toJwtHeader(@NotNull JwtAlgorithm this_, @Nullable String jwt) throws JwtException {
            return JwtUtils.Companion.toJwtHeader(jwt);
        }

        @NotNull
        public static String toJwt(@NotNull JwtAlgorithm this_, @NotNull JwtKey key, @NotNull JwtClaims claims) throws JwtException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            return this_.toJwt(key, claims, MapsKt.emptyMap());
        }

        @NotNull
        public static String toJwt(@NotNull JwtAlgorithm this_, @NotNull JwtKey key, @NotNull JwtClaims claims, @NotNull String kid) throws JwtException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
            return this_.toJwt(key, claims, MapsKt.mapOf((Pair)TuplesKt.to((Object)"kid", (Object)kid)));
        }

        @NotNull
        public static String toJwt(@NotNull JwtAlgorithm this_, @NotNull JwtKey key, @NotNull JwtClaims claims, @NotNull Map<String, ? extends Object> appendHeader) throws JwtException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            Intrinsics.checkNotNullParameter(appendHeader, (String)"appendHeader");
            String body = JwtUtils.Companion.toJwtData(MapsKt.plus(this_.defaultHeader(), appendHeader), claims.toMap());
            boolean bl = false;
            String string = new StringBuilder(512).append(body).append('.').append(this_.signature(body, key)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JwtUtils\n            .to\u2026(body, key)).toString() }");
            return string;
        }

        @NotNull
        public static JwtClaims toJwtClaimsWithoutVerify(@NotNull JwtAlgorithm this_, @Nullable String jwt) throws JwtException {
            return JwtUtils.Companion.toJwtClaimsWithoutVerify(jwt);
        }

        @Nullable
        public static JwtClaims toJwtClaimsOrNull(@NotNull JwtAlgorithm this_, @NotNull String jwt, @NotNull JwtKey key) {
            JwtClaims jwtClaims;
            Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            try {
                jwtClaims = this_.toJwtClaims(jwt, key);
            }
            catch (Exception e) {
                jwtClaims = null;
            }
            return jwtClaims;
        }
    }
}

