/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.alg.hs;

import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.saro.jwt.alg.hs.JwtHsKey;
import me.saro.jwt.core.JwtAlgorithm;
import me.saro.jwt.core.JwtClaims;
import me.saro.jwt.core.JwtHeader;
import me.saro.jwt.core.JwtKey;
import me.saro.jwt.core.JwtUtils;
import me.saro.jwt.exception.JwtException;
import me.saro.jwt.exception.JwtExceptionCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lme/saro/jwt/alg/hs/JwtHs;", "Lme/saro/jwt/core/JwtAlgorithm;", "()V", "getKeyAlgorithm", "", "getMac", "Ljavax/crypto/Mac;", "newRandomJwtKey", "Lme/saro/jwt/core/JwtKey;", "minLength", "", "maxLength", "signature", "body", "jwtKey", "toJwtClaims", "Lme/saro/jwt/core/JwtClaims;", "jwt", "key", "toJwtKey", "secret", "Companion"})
public abstract class JwtHs
implements JwtAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final char[] MOLD;
    private static final int MOLD_LEN;

    @NotNull
    public abstract String getKeyAlgorithm();

    @NotNull
    public abstract Mac getMac();

    @Override
    @NotNull
    public JwtKey toJwtKey(@NotNull String secret) throws JwtException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        try {
            object = secret;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = new JwtHsKey(new SecretKeySpec(byArray, this.getKeyAlgorithm()));
        }
        catch (Exception e) {
            throw new JwtException(JwtExceptionCode.PARSE_ERROR, null, 2, null);
        }
        return object;
    }

    @Override
    @NotNull
    public JwtKey newRandomJwtKey() {
        return this.newRandomJwtKey(32, 64);
    }

    @NotNull
    public final JwtKey newRandomJwtKey(int minLength, int maxLength) {
        if (minLength > maxLength) {
            throw new IllegalArgumentException("maxLength must be greater than minLength");
        }
        int len = minLength + (int)(Math.random() * (double)(maxLength - minLength));
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = MOLD[(int)(Math.random() * (double)MOLD_LEN)];
        }
        return this.toJwtKey(chars.toString());
    }

    @Override
    @NotNull
    public String signature(@NotNull String body, @NotNull JwtKey jwtKey) throws JwtException {
        String string;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)jwtKey, (String)"jwtKey");
        try {
            Mac mac;
            Mac $this$signature_u24lambda_u2d0 = mac = this.getMac();
            boolean bl = false;
            $this$signature_u24lambda_u2d0.init(((JwtHsKey)jwtKey).getKey());
            Mac mac2 = mac;
            String string2 = body;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = mac2.doFinal(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"mac.doFinal(body.toByteArray())");
            string = JwtUtils.Companion.encodeToBase64UrlWopString(byArray2);
        }
        catch (Exception e) {
            throw new JwtException(JwtExceptionCode.PARSE_ERROR, null, 2, null);
        }
        return string;
    }

    @Override
    @NotNull
    public JwtClaims toJwtClaims(@NotNull String jwt, @Nullable JwtKey key) throws JwtException {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        if (key == null) {
            throw new JwtException(JwtExceptionCode.JWT_KEY_IS_NULL, null, 2, null);
        }
        this.toJwtHeader(jwt).assertAlgorithm(this.algorithm());
        int firstPoint = StringsKt.indexOf$default((CharSequence)jwt, (char)'.', (int)0, (boolean)false, (int)6, null);
        int lastPoint = StringsKt.lastIndexOf$default((CharSequence)jwt, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (firstPoint < lastPoint && firstPoint != -1) {
            String string = jwt.substring(0, lastPoint);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = this.signature(string, key);
            String string3 = jwt.substring(lastPoint + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            if (Intrinsics.areEqual((Object)string2, (Object)string3)) {
                JwtClaims jwtClaims;
                JwtClaims $this$toJwtClaims_u24lambda_u2d1 = jwtClaims = JwtUtils.Companion.toJwtClaimsWithoutVerify(jwt);
                boolean bl = false;
                $this$toJwtClaims_u24lambda_u2d1.assert();
                return jwtClaims;
            }
            throw new JwtException(JwtExceptionCode.INVALID_SIGNATURE, null, 2, null);
        }
        throw new JwtException(JwtExceptionCode.PARSE_ERROR, null, 2, null);
    }

    @Override
    @NotNull
    public Map<String, Object> defaultHeader() {
        return JwtAlgorithm.DefaultImpls.defaultHeader(this);
    }

    @Override
    @NotNull
    public String toJwt(@NotNull JwtKey key, @NotNull JwtClaims claims) {
        return JwtAlgorithm.DefaultImpls.toJwt(this, key, claims);
    }

    @Override
    @NotNull
    public String toJwt(@NotNull JwtKey key, @NotNull JwtClaims claims, @NotNull String kid) {
        return JwtAlgorithm.DefaultImpls.toJwt((JwtAlgorithm)this, key, claims, kid);
    }

    @Override
    @NotNull
    public String toJwt(@NotNull JwtKey key, @NotNull JwtClaims claims, @NotNull Map<String, ? extends Object> appendHeader) {
        return JwtAlgorithm.DefaultImpls.toJwt((JwtAlgorithm)this, key, claims, appendHeader);
    }

    @Override
    @Nullable
    public JwtClaims toJwtClaimsOrNull(@NotNull String jwt, @NotNull JwtKey key) {
        return JwtAlgorithm.DefaultImpls.toJwtClaimsOrNull(this, jwt, key);
    }

    @Override
    @NotNull
    public JwtClaims toJwtClaimsWithoutVerify(@Nullable String jwt) {
        return JwtAlgorithm.DefaultImpls.toJwtClaimsWithoutVerify(this, jwt);
    }

    @Override
    @NotNull
    public JwtHeader toJwtHeader(@Nullable String jwt) {
        return JwtAlgorithm.DefaultImpls.toJwtHeader(this, jwt);
    }

    static {
        char[] cArray = "1234567890!@#$%^&*()+=-_/abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        MOLD = cArray;
        MOLD_LEN = MOLD.length;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/saro/jwt/alg/hs/JwtHs$Companion;", "", "()V", "MOLD", "", "MOLD_LEN", "", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

