/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.alg.es;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.saro.jwt.alg.es.JwtEsKey;
import me.saro.jwt.core.JwtAlgorithm;
import me.saro.jwt.core.JwtClaims;
import me.saro.jwt.core.JwtHeader;
import me.saro.jwt.core.JwtKey;
import me.saro.jwt.core.JwtUtils;
import me.saro.jwt.exception.JwtException;
import me.saro.jwt.exception.JwtExceptionCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lme/saro/jwt/alg/es/JwtEs;", "Lme/saro/jwt/core/JwtAlgorithm;", "()V", "getECGenParameterSpec", "Ljava/security/spec/ECGenParameterSpec;", "getSignature", "Ljava/security/Signature;", "newRandomJwtKey", "Lme/saro/jwt/core/JwtKey;", "signature", "", "body", "jwtKey", "toJwtClaims", "Lme/saro/jwt/core/JwtClaims;", "jwt", "key", "toJwtKey", "Companion"})
public abstract class JwtEs
implements JwtAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KEY_ALGORITHM = "EC";

    @NotNull
    public abstract ECGenParameterSpec getECGenParameterSpec();

    @NotNull
    public abstract Signature getSignature();

    @Override
    @NotNull
    public String signature(@NotNull String body, @NotNull JwtKey jwtKey) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)jwtKey, (String)"jwtKey");
        Signature signature = this.getSignature();
        signature.initSign(((JwtEsKey)jwtKey).getKeyPair().getPrivate());
        String string = body;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"signature.sign()");
        return JwtUtils.Companion.encodeToBase64UrlWopString(byArray2);
    }

    @Override
    @NotNull
    public JwtKey newRandomJwtKey() {
        KeyPairGenerator keyPairGenerator;
        KeyPairGenerator $this$newRandomJwtKey_u24lambda_u2d0 = keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        boolean bl = false;
        $this$newRandomJwtKey_u24lambda_u2d0.initialize(this.getECGenParameterSpec());
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"getInstance(KEY_ALGORITH\u2026            .genKeyPair()");
        KeyPair keyPair2 = keyPair;
        return new JwtEsKey(keyPair2);
    }

    @Override
    @NotNull
    public JwtKey toJwtKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        char[] cArray = new char[]{' '};
        List textKeyPair = StringsKt.split$default((CharSequence)key, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(JwtUtils.Companion.decodeBase64((String)textKeyPair.get(0))));
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(JwtUtils.Companion.decodeBase64((String)textKeyPair.get(1))));
        return new JwtEsKey(new KeyPair(publicKey, privateKey));
    }

    @Override
    @NotNull
    public JwtClaims toJwtClaims(@NotNull String jwt, @Nullable JwtKey key) throws JwtException {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        if (key == null) {
            throw new JwtException(JwtExceptionCode.JWT_KEY_IS_NULL, null, 2, null);
        }
        this.toJwtHeader(jwt).assertAlgorithm(this.algorithm());
        int firstPoint = StringsKt.indexOf$default((CharSequence)jwt, (char)'.', (int)0, (boolean)false, (int)6, null);
        int lastPoint = StringsKt.lastIndexOf$default((CharSequence)jwt, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (firstPoint < lastPoint && firstPoint != -1) {
            Signature signature = this.getSignature();
            signature.initVerify(((JwtEsKey)key).getKeyPair().getPublic());
            String string = jwt.substring(0, lastPoint);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Object object = string;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            signature.update(byArray);
            String string2 = jwt.substring(lastPoint + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            if (signature.verify(JwtUtils.Companion.decodeBase64Url(string2))) {
                Object $this$toJwtClaims_u24lambda_u2d1 = object = JwtUtils.Companion.toJwtClaimsWithoutVerify(jwt);
                boolean bl = false;
                ((JwtClaims)$this$toJwtClaims_u24lambda_u2d1).assert();
                return object;
            }
            throw new JwtException(JwtExceptionCode.INVALID_SIGNATURE, null, 2, null);
        }
        throw new JwtException(JwtExceptionCode.PARSE_ERROR, null, 2, null);
    }

    @Override
    @NotNull
    public Map<String, Object> defaultHeader() {
        return JwtAlgorithm.DefaultImpls.defaultHeader(this);
    }

    @Override
    @NotNull
    public String toJwt(@NotNull JwtKey key, @NotNull JwtClaims claims) {
        return JwtAlgorithm.DefaultImpls.toJwt(this, key, claims);
    }

    @Override
    @NotNull
    public String toJwt(@NotNull JwtKey key, @NotNull JwtClaims claims, @NotNull String kid) {
        return JwtAlgorithm.DefaultImpls.toJwt((JwtAlgorithm)this, key, claims, kid);
    }

    @Override
    @NotNull
    public String toJwt(@NotNull JwtKey key, @NotNull JwtClaims claims, @NotNull Map<String, ? extends Object> appendHeader) {
        return JwtAlgorithm.DefaultImpls.toJwt((JwtAlgorithm)this, key, claims, appendHeader);
    }

    @Override
    @Nullable
    public JwtClaims toJwtClaimsOrNull(@NotNull String jwt, @NotNull JwtKey key) {
        return JwtAlgorithm.DefaultImpls.toJwtClaimsOrNull(this, jwt, key);
    }

    @Override
    @NotNull
    public JwtClaims toJwtClaimsWithoutVerify(@Nullable String jwt) {
        return JwtAlgorithm.DefaultImpls.toJwtClaimsWithoutVerify(this, jwt);
    }

    @Override
    @NotNull
    public JwtHeader toJwtHeader(@Nullable String jwt) {
        return JwtAlgorithm.DefaultImpls.toJwtHeader(this, jwt);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/saro/jwt/alg/es/JwtEs$Companion;", "", "()V", "KEY_ALGORITHM", "", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

