/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.model;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lme/saro/jwt/model/KeyChain;", "Ljava/io/Serializable;", "kid", "", "algorithm", "Lio/jsonwebtoken/SignatureAlgorithm;", "keyPair", "Ljava/security/KeyPair;", "(Ljava/lang/String;Lio/jsonwebtoken/SignatureAlgorithm;Ljava/security/KeyPair;)V", "getAlgorithm", "()Lio/jsonwebtoken/SignatureAlgorithm;", "getKeyPair", "()Ljava/security/KeyPair;", "getKid", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "decrypt", "enc", "encrypt", "data", "equals", "", "other", "", "hashCode", "", "serialize", "", "toString", "Companion", "jwt"})
public final class KeyChain
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kid;
    @NotNull
    private final SignatureAlgorithm algorithm;
    @NotNull
    private final KeyPair keyPair;

    public KeyChain(@NotNull String kid, @NotNull SignatureAlgorithm algorithm, @NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        this.kid = kid;
        this.algorithm = algorithm;
        this.keyPair = keyPair;
    }

    @NotNull
    public final String getKid() {
        return this.kid;
    }

    @NotNull
    public final SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final KeyPair getKeyPair() {
        return this.keyPair;
    }

    @NotNull
    public final String encrypt(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance("RSA");
        boolean bl = false;
        boolean bl2 = false;
        Cipher $this$encrypt_u24lambda_u2d0 = cipher;
        boolean bl3 = false;
        $this$encrypt_u24lambda_u2d0.init(1, this.getKeyPair().getPrivate());
        bl = false;
        bl2 = false;
        Cipher $this$encrypt_u24lambda_u2d1 = cipher;
        boolean bl4 = false;
        Base64.Encoder encoder = Base64.getEncoder();
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl5 = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string2 = encoder.encodeToString($this$encrypt_u24lambda_u2d1.doFinal(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInstance(\"RSA\")\n     \u2026al(data.toByteArray())) }");
        return string2;
    }

    @NotNull
    public final String decrypt(@NotNull String enc) {
        Intrinsics.checkNotNullParameter((Object)enc, (String)"enc");
        Cipher cipher = Cipher.getInstance("RSA");
        boolean bl = false;
        boolean bl2 = false;
        Cipher $this$decrypt_u24lambda_u2d2 = cipher;
        boolean bl3 = false;
        $this$decrypt_u24lambda_u2d2.init(2, this.getKeyPair().getPublic());
        bl = false;
        bl2 = false;
        Cipher $this$decrypt_u24lambda_u2d3 = cipher;
        boolean bl4 = false;
        byte[] byArray = $this$decrypt_u24lambda_u2d3.doFinal(Base64.getDecoder().decode(enc));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(Base64.getDecoder().decode(enc))");
        boolean bl5 = false;
        return new String(byArray, Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object object = baos;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)object;
            boolean bl3 = false;
            Closeable closeable = new ObjectOutputStream(os);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                ObjectOutputStream it = (ObjectOutputStream)closeable;
                boolean bl6 = false;
                it.writeObject(this);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"baos.toByteArray()");
        return object;
    }

    @NotNull
    public final String component1() {
        return this.kid;
    }

    @NotNull
    public final SignatureAlgorithm component2() {
        return this.algorithm;
    }

    @NotNull
    public final KeyPair component3() {
        return this.keyPair;
    }

    @NotNull
    public final KeyChain copy(@NotNull String kid, @NotNull SignatureAlgorithm algorithm, @NotNull KeyPair keyPair) {
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        return new KeyChain(kid, algorithm, keyPair);
    }

    public static /* synthetic */ KeyChain copy$default(KeyChain keyChain, String string, SignatureAlgorithm signatureAlgorithm, KeyPair keyPair, int n, Object object) {
        if ((n & 1) != 0) {
            string = keyChain.kid;
        }
        if ((n & 2) != 0) {
            signatureAlgorithm = keyChain.algorithm;
        }
        if ((n & 4) != 0) {
            keyPair = keyChain.keyPair;
        }
        return keyChain.copy(string, signatureAlgorithm, keyPair);
    }

    @NotNull
    public String toString() {
        return "KeyChain(kid=" + this.kid + ", algorithm=" + this.algorithm + ", keyPair=" + this.keyPair + ')';
    }

    public int hashCode() {
        int result = this.kid.hashCode();
        result = result * 31 + this.algorithm.hashCode();
        result = result * 31 + this.keyPair.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyChain)) {
            return false;
        }
        KeyChain keyChain = (KeyChain)other;
        if (!Intrinsics.areEqual((Object)this.kid, (Object)keyChain.kid)) {
            return false;
        }
        if (this.algorithm != keyChain.algorithm) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.keyPair, (Object)keyChain.keyPair);
    }

    @JvmStatic
    @NotNull
    public static final KeyChain deserialize(@NotNull byte[] serialize) {
        return Companion.deserialize(serialize);
    }

    @JvmStatic
    @NotNull
    public static final KeyChain create(@NotNull String kid, @NotNull SignatureAlgorithm algorithm) {
        return Companion.create(kid, algorithm);
    }

    @JvmStatic
    @NotNull
    public static final KeyChain create(@NotNull SignatureAlgorithm algorithm) {
        return Companion.create(algorithm);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lme/saro/jwt/model/KeyChain$Companion;", "", "()V", "create", "Lme/saro/jwt/model/KeyChain;", "algorithm", "Lio/jsonwebtoken/SignatureAlgorithm;", "kid", "", "deserialize", "serialize", "", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final KeyChain deserialize(@NotNull byte[] serialize) {
            KeyChain keyChain;
            Intrinsics.checkNotNullParameter((Object)serialize, (String)"serialize");
            ByteArrayInputStream bois = new ByteArrayInputStream(serialize);
            Closeable closeable = bois;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                KeyChain keyChain2;
                ByteArrayInputStream os = (ByteArrayInputStream)closeable;
                boolean bl3 = false;
                Closeable closeable2 = new ObjectInputStream(os);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)closeable2;
                    boolean bl6 = false;
                    Object object = it.readObject();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type me.saro.jwt.model.KeyChain");
                    }
                    keyChain2 = (KeyChain)object;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                keyChain = keyChain2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return keyChain;
        }

        @JvmStatic
        @NotNull
        public final KeyChain create(@NotNull String kid, @NotNull SignatureAlgorithm algorithm) {
            Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            KeyPair keyPair = Keys.keyPairFor((SignatureAlgorithm)algorithm);
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"keyPairFor(algorithm)");
            return new KeyChain(kid, algorithm, keyPair);
        }

        @JvmStatic
        @NotNull
        public final KeyChain create(@NotNull SignatureAlgorithm algorithm) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            return this.create(string, algorithm);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

