/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.io;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.saro.jwt.model.ClaimName;
import me.saro.jwt.model.KeyChain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"Lme/saro/jwt/io/JwtReader;", "", "jwt", "Lio/jsonwebtoken/Jws;", "Lio/jsonwebtoken/Claims;", "keyChain", "Lme/saro/jwt/model/KeyChain;", "(Lio/jsonwebtoken/Jws;Lme/saro/jwt/model/KeyChain;)V", "claim", "name", "", "Lme/saro/jwt/model/ClaimName;", "decryptClaim", "header", "key"})
public final class JwtReader {
    @NotNull
    private final Jws<Claims> jwt;
    @NotNull
    private final KeyChain keyChain;

    public JwtReader(@NotNull Jws<Claims> jwt, @NotNull KeyChain keyChain) {
        Intrinsics.checkNotNullParameter(jwt, (String)"jwt");
        Intrinsics.checkNotNullParameter((Object)keyChain, (String)"keyChain");
        this.jwt = jwt;
        this.keyChain = keyChain;
    }

    @Nullable
    public final Object header(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((JwsHeader)this.jwt.getHeader()).get((Object)key);
    }

    @Nullable
    public final Object claim(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ((Claims)this.jwt.getBody()).get((Object)name);
    }

    @Nullable
    public final Object claim(@NotNull ClaimName name) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        return this.claim(name.getValue());
    }

    @Nullable
    public final String decryptClaim(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = ((Claims)this.jwt.getBody()).get((Object)name);
        if (object == null) {
            string = null;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$decryptClaim_u24lambda_u2d0 = object2;
            boolean bl3 = false;
            string = this.keyChain.decrypt($this$decryptClaim_u24lambda_u2d0.toString());
        }
        return string;
    }

    @Nullable
    public final String decryptClaim(@NotNull ClaimName name) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        return this.decryptClaim(name.getValue());
    }
}

