/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt.io;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.saro.jwt.model.ClaimName;
import me.saro.jwt.model.KeyChain;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001J \u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0001J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/saro/jwt/io/JwtBuilder;", "", "signatureAlgorithm", "Lio/jsonwebtoken/SignatureAlgorithm;", "keyChain", "Lme/saro/jwt/model/KeyChain;", "(Lio/jsonwebtoken/SignatureAlgorithm;Lme/saro/jwt/model/KeyChain;)V", "header", "", "", "claims", "(Lio/jsonwebtoken/SignatureAlgorithm;Lme/saro/jwt/model/KeyChain;Ljava/util/Map;Ljava/util/Map;)V", "build", "claim", "name", "value", "check", "", "Lme/saro/jwt/model/ClaimName;", "encryptClaim", "key", "setExpireMinutes", "minutes", "", "setExpireSeconds", "seconds", "setIssuedAtNow", "jwt"})
public final class JwtBuilder {
    @NotNull
    private final SignatureAlgorithm signatureAlgorithm;
    @NotNull
    private final KeyChain keyChain;
    @NotNull
    private final Map<String, Object> header;
    @NotNull
    private final Map<String, Object> claims;

    public JwtBuilder(@NotNull SignatureAlgorithm signatureAlgorithm, @NotNull KeyChain keyChain, @NotNull Map<String, Object> header, @NotNull Map<String, Object> claims) {
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)keyChain, (String)"keyChain");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        this.signatureAlgorithm = signatureAlgorithm;
        this.keyChain = keyChain;
        this.header = header;
        this.claims = claims;
        Map<String, Object> map = this.header;
        String string = "kid";
        String string2 = this.keyChain.getKid();
        boolean bl = false;
        map.put(string, string2);
        map = this.header;
        string = "alg";
        string2 = this.signatureAlgorithm;
        bl = false;
        map.put(string, string2);
        if (this.signatureAlgorithm != this.keyChain.getAlgorithm()) {
            throw new IllegalArgumentException("signatureAlgorithm and keyChain.algorithm does not match algorithm");
        }
    }

    public JwtBuilder(@NotNull SignatureAlgorithm signatureAlgorithm, @NotNull KeyChain keyChain) {
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)keyChain, (String)"keyChain");
        boolean bl = false;
        bl = false;
        this(signatureAlgorithm, keyChain, new LinkedHashMap(), new LinkedHashMap());
    }

    @NotNull
    public final JwtBuilder header(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (key) {
            case "": 
            case "kid": 
            case "alg": {
                throw new IllegalArgumentException('[' + key + "] has not allow header key name");
            }
        }
        Object object = this.header;
        boolean bl = false;
        object.put(key, value);
        return this;
    }

    private final JwtBuilder claim(String name, Object value, boolean check) {
        block13: {
            if (!check) break block13;
            switch (name) {
                case "exp": {
                    throw new IllegalArgumentException("use setExpire*() instead of claim(\"exp\")");
                }
                case "iat": {
                    throw new IllegalArgumentException("use setIssuedAtNow() instead of claim(\"iat\")");
                }
                case "": {
                    throw new IllegalArgumentException("name must not empty");
                }
            }
        }
        Object object = this.claims;
        boolean bl = false;
        object.put(name, value);
        return this;
    }

    @NotNull
    public final JwtBuilder claim(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim(name, value, true);
    }

    @NotNull
    public final JwtBuilder claim(@NotNull ClaimName name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim(name.getValue(), value, true);
    }

    @NotNull
    public final JwtBuilder encryptClaim(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim(name, this.keyChain.encrypt(value), true);
    }

    @NotNull
    public final JwtBuilder encryptClaim(@NotNull ClaimName name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.claim(name.getValue(), this.keyChain.encrypt(value), true);
    }

    @NotNull
    public final JwtBuilder setIssuedAtNow() {
        return this.claim("iat", new Date().getTime() / (long)1000, false);
    }

    @NotNull
    public final JwtBuilder setExpireSeconds(int seconds) {
        return this.claim("exp", new Date().getTime() / (long)1000 + (long)seconds, false);
    }

    @NotNull
    public final JwtBuilder setExpireMinutes(int minutes) {
        return this.setExpireSeconds(minutes * 60);
    }

    @NotNull
    public final String build() {
        Object v;
        boolean bl;
        Map.Entry<String, Object> entry;
        String n;
        Map.Entry<String, Object> $dstr$n$v;
        Map.Entry<String, Object> element$iv;
        io.jsonwebtoken.JwtBuilder build = Jwts.builder().setHeaderParam("kid", (Object)this.keyChain.getKid()).signWith((Key)this.keyChain.getKeyPair().getPrivate(), this.signatureAlgorithm);
        Map<String, Object> $this$forEach$iv = this.header;
        boolean $i$f$forEach = false;
        Map<String, Object> map = $this$forEach$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            $dstr$n$v = element$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry<String, Object> entry2 = $dstr$n$v;
            boolean bl4 = false;
            n = entry2.getKey();
            entry = $dstr$n$v;
            bl = false;
            v = entry.getValue();
            build.setHeaderParam(n, v);
        }
        $this$forEach$iv = this.claims;
        $i$f$forEach = false;
        map = $this$forEach$iv;
        bl2 = false;
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            $dstr$n$v = element$iv = iterator.next();
            boolean bl5 = false;
            v = $dstr$n$v;
            boolean bl6 = false;
            n = v.getKey();
            entry = $dstr$n$v;
            bl = false;
            v = entry.getValue();
            build.claim(n, v);
        }
        String string = build.compact();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"build.compact()");
        return string;
    }
}

