/*
 * Decompiled with CFR 0.152.
 */
package me.saro.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.jsonwebtoken.security.SecurityException;
import java.io.Serializable;
import java.security.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.saro.jwt.JwtKeyManager;
import me.saro.jwt.io.JwtBuilder;
import me.saro.jwt.io.JwtReader;
import me.saro.jwt.model.KeyChain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002*\u0001\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0007H&J\b\u0010\r\u001a\u00020\u000eH&J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\b\u0010\u0012\u001a\u00020\u0013H&R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lme/saro/jwt/JwtKeyManager;", "", "()V", "signingKeyResolverAdapter", "me/saro/jwt/JwtKeyManager$signingKeyResolverAdapter$1", "Lme/saro/jwt/JwtKeyManager$signingKeyResolverAdapter$1;", "findKeySet", "Lme/saro/jwt/model/KeyChain;", "kid", "", "getJwtBuilder", "Lme/saro/jwt/io/JwtBuilder;", "getKeyChain", "getSignatureAlgorithm", "Lio/jsonwebtoken/SignatureAlgorithm;", "parse", "Lme/saro/jwt/io/JwtReader;", "jwt", "rotate", ""})
public abstract class JwtKeyManager {
    @NotNull
    private final signingKeyResolverAdapter.1 signingKeyResolverAdapter = new SigningKeyResolverAdapter(this){
        final /* synthetic */ JwtKeyManager this$0;
        {
            this.this$0 = $receiver;
        }

        @NotNull
        public Key resolveSigningKey(@NotNull JwsHeader<?> header, @NotNull Claims claims) throws SecurityException {
            KeyChain keyChain;
            Intrinsics.checkNotNullParameter(header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
            String string = (String)header.get((Object)"kid");
            if (string == null) {
                keyChain = null;
            } else {
                String string2 = string;
                JwtKeyManager jwtKeyManager = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                keyChain = jwtKeyManager.findKeySet(it);
            }
            Serializable serializable = keyChain;
            if (serializable == null) {
                throw new java.lang.SecurityException("does not found kid in jwt");
            }
            KeyChain keyChain2 = serializable;
            if (!Intrinsics.areEqual((Object)((String)header.get((Object)"alg")), (Object)keyChain2.getAlgorithm().name())) {
                throw new java.lang.SecurityException("does not match algorithm: jwt.algorithm != keyChain.algorithm");
            }
            serializable = keyChain2.getKeyPair().getPrivate();
            Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"keyChain.keyPair.private");
            return (Key)serializable;
        }
    };

    @NotNull
    public abstract SignatureAlgorithm getSignatureAlgorithm();

    @NotNull
    public abstract KeyChain getKeyChain();

    public abstract void rotate();

    @NotNull
    public abstract KeyChain findKeySet(@Nullable String var1) throws java.lang.SecurityException;

    @NotNull
    public final JwtBuilder getJwtBuilder() {
        return new JwtBuilder(this.getSignatureAlgorithm(), this.getKeyChain());
    }

    @NotNull
    public final JwtReader parse(@NotNull String jwt) throws SecurityException {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        Jws jwtClaims = Jwts.parserBuilder().setSigningKeyResolver((SigningKeyResolver)this.signingKeyResolverAdapter).build().parseClaimsJws(jwt);
        Intrinsics.checkNotNullExpressionValue((Object)jwtClaims, (String)"jwtClaims");
        return new JwtReader((Jws<Claims>)jwtClaims, this.findKeySet((String)((JwsHeader)jwtClaims.getHeader()).get((Object)"kid")));
    }
}

