/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.web;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class WebResult<T> {
    private int status = -1;
    private Exception exception;
    private Map<String, List<String>> headers = Collections.emptyMap();
    private T body;
    private String errorBody;

    WebResult() {
    }

    public boolean isSuccess() {
        return this.isStatus2xx() && this.exception == null;
    }

    public boolean isStatus2xx() {
        return this.status >= 200 && this.status < 300;
    }

    public boolean isStatus3xx() {
        return this.status >= 300 && this.status < 400;
    }

    public boolean isStatus4xx() {
        return this.status >= 400 && this.status < 500;
    }

    public boolean isStatus5xx() {
        return this.status >= 500 && this.status < 600;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public T getBody() {
        return this.body;
    }

    public T getBody(T orElse) {
        return this.body != null ? this.body : orElse;
    }

    public <X extends Throwable> T getBodyWithThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.body == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.body;
    }

    public T getBodyWithThrow() throws NullPointerException {
        return this.getBodyWithThrow(NullPointerException::new);
    }

    public String getErrorBody() {
        return this.errorBody;
    }

    public String getErrorBody(String orElse) {
        return this.errorBody != null ? this.errorBody : orElse;
    }

    public String toString() {
        return "WebResult(status=" + this.getStatus() + ")";
    }

    public int getStatus() {
        return this.status;
    }

    void setStatus(int status) {
        this.status = status;
    }

    public Exception getException() {
        return this.exception;
    }

    void setException(Exception exception) {
        this.exception = exception;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    void setBody(T body) {
        this.body = body;
    }

    void setErrorBody(String errorBody) {
        this.errorBody = errorBody;
    }
}

