/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import me.saro.commons.Converter;
import me.saro.commons.function.ThrowableFunction;
import me.saro.commons.web.Web;
import me.saro.commons.web.WebIgnoreCertificate;
import me.saro.commons.web.WebResult;

public class BasicWeb
implements Web {
    final String url;
    final String method;
    String requestCharset = "UTF-8";
    String responseCharset = "UTF-8";
    StringBuilder urlParameter = new StringBuilder(100);
    Map<String, String> header = new HashMap<String, String>();
    ByteArrayOutputStream body = new ByteArrayOutputStream(8192);
    boolean ignoreCertificate = false;
    int connectTimeout;
    int readTimeout;

    protected BasicWeb(String url, String method) {
        int point = url.indexOf(63);
        if (point > -1) {
            if (point < url.length()) {
                this.urlParameter.append(url.substring(point));
            }
            url = url.substring(0, point);
        } else {
            this.urlParameter.append('?');
        }
        this.url = url;
        this.method = method;
    }

    @Override
    public Web setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public Web setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Web setRequestCharset(String charset) {
        this.requestCharset = charset;
        return this;
    }

    @Override
    public Web setResponseCharset(String charset) {
        this.responseCharset = charset;
        return this;
    }

    @Override
    public Web setIgnoreCertificate(boolean ignoreCertificate) {
        this.ignoreCertificate = ignoreCertificate;
        return this;
    }

    @Override
    public Web addUrlParameter(String name, String value) {
        try {
            if (this.urlParameter.length() > 1) {
                this.urlParameter.append('&');
            }
            this.urlParameter.append(name).append('=').append(URLEncoder.encode(value, this.requestCharset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Web setHeader(String name, String value) {
        this.header.put(name, value);
        return this;
    }

    @Override
    public Web writeBody(byte[] bytes) {
        try {
            this.body.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Web writeBodyParameter(String name, String value) {
        if (this.body.size() > 0) {
            this.body.write(38);
        }
        try {
            this.body.write(URLEncoder.encode(name, this.requestCharset).getBytes());
            this.body.write(61);
            this.body.write(URLEncoder.encode(value, this.requestCharset).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public <R> WebResult<R> toCustom(WebResult<R> result, ThrowableFunction<InputStream, R> function) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(this.urlParameter.length() > 1 ? this.url + this.urlParameter.toString() : this.url).openConnection();
            if (this.ignoreCertificate) {
                WebIgnoreCertificate.ignoreCertificate(connection);
            }
            if (this.connectTimeout > 0) {
                connection.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout > 0) {
                connection.setReadTimeout(this.readTimeout);
            }
            this.header.forEach(connection::setRequestProperty);
            if (this.body.size() > 0) {
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(this.body.toByteArray());
                    os.flush();
                }
            }
            result.setStatus(connection.getResponseCode());
            result.setHeaders(connection.getHeaderFields());
            try (InputStream is = connection.getInputStream();){
                try {
                    result.setBody(function.apply(is));
                }
                catch (Exception e) {
                    result.setException(new Exception("TYPE CAST ERROR : " + e.getMessage(), e));
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException ie) {
                result.setErrorBody(Converter.toString(connection.getErrorStream(), this.getResponseCharset()));
            }
        }
        catch (Exception e) {
            result.setException(e);
        }
        return result;
    }

    @Override
    public String getRequestCharset() {
        return this.requestCharset;
    }

    @Override
    public String getResponseCharset() {
        return this.responseCharset;
    }
}

