/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.saro.commons.Utils;

public class SSHExecutor
implements Closeable {
    final Session session;
    final String charset;

    private SSHExecutor(String host, int port, String user, String pass, String charset) throws IOException {
        try {
            this.charset = charset;
            this.session = new JSch().getSession(user, host, port);
            this.session.setPassword(pass);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect();
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    public static SSHExecutor open(String host, int port, String user, String pass, String charset) throws IOException {
        return new SSHExecutor(host, port, user, pass, charset);
    }

    public static String just(String host, int port, String user, String pass, String charset, String ... cmds) throws IOException {
        String rv;
        try (SSHExecutor ssh = SSHExecutor.open(host, port, user, pass, charset);){
            rv = ssh.cmd(cmds);
        }
        return rv;
    }

    public synchronized String cmd(String ... cmds) throws IOException {
        String rv = null;
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)this.session.openChannel("exec");
            channel.setCommand(Optional.ofNullable(cmds).filter(e -> ((String[])e).length > 0).map(Stream::of).map(e -> e.collect(Collectors.joining("\n", "", "\n"))).orElseThrow(() -> new IllegalArgumentException("there is no command")).getBytes(this.charset));
            channel.connect();
            try (InputStream is = channel.getInputStream();
                 InputStream eis = channel.getErrStream();){
                rv = Utils.nvl(Utils.bvl(this.read(is), this.read(eis)), "");
            }
        }
        catch (JSchException je) {
            throw new IOException(je);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        return rv;
    }

    private String read(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        while ((ch = is.read()) != -1) {
            baos.write(ch);
        }
        String rv = baos.toString(this.charset);
        return rv;
    }

    @Override
    public void close() throws IOException {
        try {
            this.session.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

