/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes.fd;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.saro.commons.bytes.fd.FixedMethod;
import me.saro.commons.bytes.fd.FixedMethodBinaryType;
import me.saro.commons.bytes.fd.FixedMethodConsumer;
import me.saro.commons.bytes.fd.FixedMethodDateType;
import me.saro.commons.bytes.fd.FixedMethodTextType;
import me.saro.commons.bytes.fd.annotations.BinaryData;
import me.saro.commons.bytes.fd.annotations.DateData;
import me.saro.commons.bytes.fd.annotations.FixedDataClass;
import me.saro.commons.bytes.fd.annotations.TextData;

public class FixedMethodUtils {
    public static List<FixedMethodConsumer> toBytesConsumers(FixedDataClass fixedDataClassInfo, Class<?> clazz, Field[] fields) {
        ArrayList<FixedMethodConsumer> list = new ArrayList<FixedMethodConsumer>();
        for (Field field : fields) {
            Method method;
            FixedMethod fixedMethod = FixedMethodUtils.getFixedMethod(fixedDataClassInfo, clazz, field);
            if (fixedMethod == null || (method = FixedMethodUtils.getMethod(clazz, field, "get")) == null) continue;
            list.add(fixedMethod.toBytes(method));
        }
        return list;
    }

    public static List<FixedMethodConsumer> toClassConsumers(FixedDataClass fixedDataClassInfo, Class<?> clazz, Field[] fields) {
        ArrayList<FixedMethodConsumer> list = new ArrayList<FixedMethodConsumer>();
        for (Field field : fields) {
            Method method;
            FixedMethod fixedMethod = FixedMethodUtils.getFixedMethod(fixedDataClassInfo, clazz, field);
            if (fixedMethod == null || (method = FixedMethodUtils.getMethod(clazz, field, "set")) == null) continue;
            list.add(fixedMethod.toClass(method));
        }
        return list;
    }

    private static FixedMethod getFixedMethod(FixedDataClass fixedDataClassInfo, Class<?> clazz, Field field) {
        int cnt = 0;
        List<Annotation> annotations = Arrays.asList(field.getDeclaredAnnotation(TextData.class), field.getDeclaredAnnotation(BinaryData.class), field.getDeclaredAnnotation(DateData.class));
        Annotation dataType = null;
        for (Annotation annotation : annotations) {
            if (annotation == null) continue;
            ++cnt;
            dataType = annotation;
        }
        if (cnt == 1) {
            switch (dataType.annotationType().getSimpleName()) {
                case "BinaryData": {
                    return new FixedMethodBinaryType(clazz.getName(), (BinaryData)dataType);
                }
                case "TextData": {
                    return new FixedMethodTextType(fixedDataClassInfo, clazz.getName(), (TextData)dataType);
                }
                case "DateData": {
                    return new FixedMethodDateType(clazz.getName(), (DateData)dataType);
                }
            }
        } else if (cnt > 1) {
            throw new IllegalArgumentException("one data field must have one data field annotation but " + clazz.getName() + "." + field.getName() + " have many annotations : " + annotations.stream().map(e -> "@" + e.annotationType().getName()).collect(Collectors.joining(", ")));
        }
        return null;
    }

    private static Method getMethod(Class<?> clazz, Field field, String type) {
        String fieldName = field.getName();
        String methodName = type + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        List methods = Stream.of(clazz.getDeclaredMethods()).filter(e -> e.getName().equals(methodName)).filter(e -> type.equals("get") && e.getParameterCount() == 0 && !e.getReturnType().getTypeName().toString().equals("void") || type.equals("set") && e.getParameterCount() == 1).collect(Collectors.toList());
        if (methods.size() > 1) {
            throw new IllegalArgumentException("duplicate method name : " + methods.stream().map(e -> e.getReturnType().toString() + " " + e.getName() + "(" + (type.equals("get") ? "" : e.getGenericParameterTypes()[0].getTypeName()) + ")").collect(Collectors.joining(", ")) + " in class" + clazz.getName());
        }
        return methods.size() == 1 ? (Method)methods.get(0) : null;
    }
}

