/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes.fd;

import java.lang.reflect.Method;
import java.util.Arrays;
import me.saro.commons.bytes.Bytes;
import me.saro.commons.bytes.fd.FixedMethod;
import me.saro.commons.bytes.fd.FixedMethodConsumer;
import me.saro.commons.bytes.fd.annotations.FixedDataClass;
import me.saro.commons.bytes.fd.annotations.TextData;
import me.saro.commons.bytes.fd.annotations.TextDataAlign;

public class FixedMethodTextType
implements FixedMethod {
    static final byte[] EMPTY_BYTES = new byte[0];
    final TextData meta;
    final String parentClassName;
    final FixedDataClass fixedDataClassInfo;

    FixedMethodTextType(FixedDataClass fixedDataClassInfo, String parentClassName, TextData textData) {
        this.fixedDataClassInfo = fixedDataClassInfo;
        this.meta = textData;
        this.parentClassName = parentClassName;
    }

    @Override
    public FixedMethodConsumer toBytes(Method method) {
        String genericReturnTypeName;
        int offset = this.meta.offset();
        int length = this.meta.length();
        boolean isLeft = this.meta.align() == TextDataAlign.left;
        boolean unsigned = this.meta.unsigned();
        String charset = "".equals(this.meta.charset()) ? this.fixedDataClassInfo.charset() : this.meta.charset();
        int radix = this.meta.radix();
        byte fill = this.meta.fill();
        switch (genericReturnTypeName = method.getGenericReturnType().getTypeName()) {
            case "java.lang.String": {
                return (bytes, idx, val) -> this.bindBytes(bytes, offset + idx, this.toBytes((String)method.invoke(val, new Object[0]), charset), length, fill, isLeft, method);
            }
            case "byte": 
            case "java.lang.Byte": {
                return (bytes, idx, val) -> this.bindBytes(bytes, offset + idx, Integer.toString(unsigned ? Byte.toUnsignedInt((Byte)method.invoke(val, new Object[0])) : (Byte)method.invoke(val, new Object[0]), radix).getBytes(), length, fill, isLeft, method);
            }
            case "short": 
            case "java.lang.Short": {
                return (bytes, idx, val) -> this.bindBytes(bytes, offset + idx, Integer.toString(unsigned ? Short.toUnsignedInt((Short)method.invoke(val, new Object[0])) : (Short)method.invoke(val, new Object[0]), radix).getBytes(), length, fill, isLeft, method);
            }
            case "int": 
            case "java.lang.Integer": {
                return (bytes, idx, val) -> this.bindBytes(bytes, offset + idx, (unsigned ? Integer.toUnsignedString((Integer)method.invoke(val, new Object[0]), radix) : Integer.toString((Integer)method.invoke(val, new Object[0]), radix)).getBytes(), length, fill, isLeft, method);
            }
            case "long": 
            case "java.lang.Long": {
                return (bytes, idx, val) -> this.bindBytes(bytes, offset + idx, (unsigned ? Long.toUnsignedString((Long)method.invoke(val, new Object[0]), radix) : Long.toString((Long)method.invoke(val, new Object[0]), radix)).getBytes(), length, fill, isLeft, method);
            }
            case "float": 
            case "java.lang.Float": {
                return (bytes, idx, val) -> this.bindBytes(bytes, offset + idx, Float.toString(((Float)method.invoke(val, new Object[0])).floatValue()).getBytes(), length, fill, isLeft, method);
            }
            case "double": 
            case "java.lang.Double": {
                return (bytes, idx, val) -> this.bindBytes(bytes, offset + idx, Double.toString((Double)method.invoke(val, new Object[0])).getBytes(), length, fill, isLeft, method);
            }
        }
        throw new IllegalArgumentException("does not support return type of " + genericReturnTypeName + " " + method.getName() + "() in " + this.parentClassName);
    }

    @Override
    public FixedMethodConsumer toClass(Method method) {
        String genericParameterTypeName;
        int offset = this.meta.offset();
        int length = this.meta.length();
        boolean isLeft = this.meta.align() == TextDataAlign.left;
        boolean unsigned = this.meta.unsigned();
        String charset = "".equals(this.meta.charset()) ? this.fixedDataClassInfo.charset() : this.meta.charset();
        int radix = this.meta.radix();
        byte fill = this.meta.fill();
        boolean emptyIsNull = this.meta.emptyIsNull();
        switch (genericParameterTypeName = method.getGenericParameterTypes()[0].getTypeName()) {
            case "java.lang.String": {
                return (bytes, idx, val) -> method.invoke(val, this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, emptyIsNull));
            }
            case "byte": 
            case "java.lang.Byte": {
                return (bytes, idx, val) -> method.invoke(val, (byte)Integer.parseInt(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false), radix));
            }
            case "short": 
            case "java.lang.Short": {
                return (bytes, idx, val) -> method.invoke(val, (short)Integer.parseInt(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false), radix));
            }
            case "int": 
            case "java.lang.Integer": {
                return (bytes, idx, val) -> method.invoke(val, unsigned ? (int)Long.parseLong(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false), radix) : Integer.parseInt(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false), radix));
            }
            case "long": 
            case "java.lang.Long": {
                return (bytes, idx, val) -> method.invoke(val, unsigned ? Long.parseUnsignedLong(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false), radix) : Long.parseLong(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false), radix));
            }
            case "float": 
            case "java.lang.Float": {
                return (bytes, idx, val) -> method.invoke(val, Float.valueOf(Float.parseFloat(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false))));
            }
            case "double": 
            case "java.lang.Double": {
                return (bytes, idx, val) -> method.invoke(val, Double.parseDouble(this.newString(bytes, this.getIndexWithoutFill(bytes, offset + idx, length, fill, isLeft), charset, false)));
            }
        }
        throw new IllegalArgumentException("does not support parameter type of void " + method.getName() + "(" + genericParameterTypeName + ") in the " + this.parentClassName);
    }

    public byte[] toBytes(String text, String charset) {
        return text != null ? text.getBytes(charset) : EMPTY_BYTES;
    }

    public String newString(byte[] bytes, int[] fi, String charset, boolean emptyIsNull) {
        return fi[0] == fi[1] ? (emptyIsNull ? null : "") : new String(bytes, fi[0], fi[1] - fi[0], charset);
    }

    private int[] getIndexWithoutFill(byte[] data, int dataOffset, int dataLength, byte fill, boolean isLeft) {
        int lidx;
        if (isLeft) {
            int sidx = dataOffset;
            int eidx = dataOffset;
            for (int i = dataOffset + dataLength - 1; i >= dataOffset; --i) {
                if (fill == data[i]) continue;
                eidx = i + 1;
                break;
            }
            return new int[]{sidx, eidx};
        }
        int sidx = lidx = dataOffset + dataLength;
        int eidx = lidx;
        for (int i = dataOffset; i < lidx; ++i) {
            if (fill == data[i]) continue;
            sidx = i;
            break;
        }
        return new int[]{sidx, eidx};
    }

    private void bindBytes(byte[] out, int outOffset, byte[] data, int dataLength, byte fill, boolean isLeft, Method method) {
        int size = data.length;
        if (size > dataLength) {
            throw new RuntimeException("overflow " + this.parentClassName + "." + method.getName() + "() : limit[" + dataLength + "], size[" + size + "] : hex_data " + Bytes.toHex(data));
        }
        if (size == dataLength) {
            System.arraycopy(data, 0, out, outOffset, dataLength);
        }
        if (isLeft) {
            System.arraycopy(data, 0, out, outOffset, size);
            Arrays.fill(out, outOffset + size, outOffset + dataLength, fill);
        } else {
            int offsetDef = outOffset + dataLength - size;
            System.arraycopy(data, 0, out, offsetDef, size);
            Arrays.fill(out, outOffset, offsetDef, fill);
        }
    }
}

