/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes.fd;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import me.saro.commons.DateFormat;
import me.saro.commons.bytes.Bytes;
import me.saro.commons.bytes.fd.FixedMethod;
import me.saro.commons.bytes.fd.FixedMethodConsumer;
import me.saro.commons.bytes.fd.annotations.DateData;
import me.saro.commons.bytes.fd.annotations.DateDataType;

public class FixedMethodDateType
implements FixedMethod {
    final DateData meta;
    final String parentClassName;

    FixedMethodDateType(String parentClassName, DateData dateDate) {
        this.meta = dateDate;
        this.parentClassName = parentClassName;
    }

    @Override
    public FixedMethodConsumer toBytes(Method method) {
        String genericReturnTypeName;
        int offset = this.meta.offset();
        DateDataType type = this.meta.type();
        switch (genericReturnTypeName = method.getGenericReturnType().getTypeName()) {
            case "java.util.Date": {
                switch (type) {
                    case millis8: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(((Date)method.invoke(val, new Object[0])).getTime()), 0, bytes, offset + idx, 8);
                    }
                    case unix8: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(((Date)method.invoke(val, new Object[0])).getTime() / 1000L), 0, bytes, offset + idx, 8);
                    }
                    case unix4: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((int)(((Date)method.invoke(val, new Object[0])).getTime() / 1000L)), 0, bytes, offset + idx, 4);
                    }
                }
                break;
            }
            case "java.util.Calendar": {
                switch (type) {
                    case millis8: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(((Calendar)method.invoke(val, new Object[0])).getTimeInMillis()), 0, bytes, offset + idx, 8);
                    }
                    case unix8: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(((Calendar)method.invoke(val, new Object[0])).getTimeInMillis() / 1000L), 0, bytes, offset + idx, 8);
                    }
                    case unix4: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((int)(((Calendar)method.invoke(val, new Object[0])).getTimeInMillis() / 1000L)), 0, bytes, offset + idx, 4);
                    }
                }
                break;
            }
            case "me.saro.commons.DateFormat": {
                switch (type) {
                    case millis8: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(((DateFormat)method.invoke(val, new Object[0])).getTimeInMillis()), 0, bytes, offset + idx, 8);
                    }
                    case unix8: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(((DateFormat)method.invoke(val, new Object[0])).getTimeInMillis() / 1000L), 0, bytes, offset + idx, 8);
                    }
                    case unix4: {
                        return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((int)(((DateFormat)method.invoke(val, new Object[0])).getTimeInMillis() / 1000L)), 0, bytes, offset + idx, 4);
                    }
                }
            }
        }
        throw new IllegalArgumentException("does not support type, support type [Date, Calendar, DateFormat] : " + genericReturnTypeName + " " + method.getName() + "() in " + this.parentClassName);
    }

    @Override
    public FixedMethodConsumer toClass(Method method) {
        String genericParameterTypeName;
        int offset = this.meta.offset();
        DateDataType type = this.meta.type();
        switch (genericParameterTypeName = method.getGenericParameterTypes()[0].getTypeName()) {
            case "java.util.Date": {
                switch (type) {
                    case millis8: {
                        return (bytes, idx, val) -> method.invoke(val, new Date(Bytes.toLong(bytes, idx + offset)));
                    }
                    case unix8: {
                        return (bytes, idx, val) -> method.invoke(val, new Date(Bytes.toLong(bytes, idx + offset) * 1000L));
                    }
                    case unix4: {
                        return (bytes, idx, val) -> method.invoke(val, new Date(Integer.toUnsignedLong(Bytes.toInt(bytes, idx + offset)) * 1000L));
                    }
                }
                break;
            }
            case "java.util.Calendar": {
                switch (type) {
                    case millis8: {
                        return (bytes, idx, val) -> method.invoke(val, DateFormat.parse(Bytes.toLong(bytes, idx + offset)).toCalendar());
                    }
                    case unix8: {
                        return (bytes, idx, val) -> method.invoke(val, DateFormat.parse(Bytes.toLong(bytes, idx + offset) * 1000L).toCalendar());
                    }
                    case unix4: {
                        return (bytes, idx, val) -> method.invoke(val, DateFormat.parse(Integer.toUnsignedLong(Bytes.toInt(bytes, idx + offset)) * 1000L).toCalendar());
                    }
                }
                break;
            }
            case "me.saro.commons.DateFormat": {
                switch (type) {
                    case millis8: {
                        return (bytes, idx, val) -> method.invoke(val, DateFormat.parse(Bytes.toLong(bytes, idx + offset)));
                    }
                    case unix8: {
                        return (bytes, idx, val) -> method.invoke(val, DateFormat.parse(Bytes.toLong(bytes, idx + offset) * 1000L));
                    }
                    case unix4: {
                        return (bytes, idx, val) -> method.invoke(val, DateFormat.parse(Integer.toUnsignedLong(Bytes.toInt(bytes, idx + offset)) * 1000L));
                    }
                }
            }
        }
        throw new IllegalArgumentException("does not support type, support type [Date, Calendar, DateFormat] : " + method.getName() + "(" + genericParameterTypeName + ") in the " + this.parentClassName);
    }
}

