/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes.fd;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.saro.commons.Converter;
import me.saro.commons.bytes.Bytes;
import me.saro.commons.bytes.fd.FixedData;
import me.saro.commons.bytes.fd.FixedMethod;
import me.saro.commons.bytes.fd.FixedMethodConsumer;
import me.saro.commons.bytes.fd.annotations.BinaryData;
import me.saro.commons.bytes.fd.annotations.FixedDataClass;

public class FixedMethodBinaryType
implements FixedMethod {
    final BinaryData meta;
    final String parentClassName;

    FixedMethodBinaryType(String parentClassName, BinaryData binaryData) {
        this.meta = binaryData;
        this.parentClassName = parentClassName;
    }

    @Override
    public FixedMethodConsumer toBytes(Method method) {
        int arrayLength = this.meta.arrayLength();
        int offset = this.meta.offset();
        Type genericReturnType = method.getGenericReturnType();
        String genericReturnTypeName = genericReturnType.getTypeName();
        Class<?> returnTypeClass = method.getReturnType();
        switch (genericReturnTypeName) {
            case "byte": 
            case "java.lang.Byte": {
                return (bytes, idx, val) -> {
                    bytes[offset + idx] = (Byte)method.invoke(val, new Object[0]);
                };
            }
            case "short": 
            case "java.lang.Short": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((Short)method.invoke(val, new Object[0])), 0, bytes, offset + idx, 2);
            }
            case "int": 
            case "java.lang.Integer": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((Integer)method.invoke(val, new Object[0])), 0, bytes, offset + idx, 4);
            }
            case "long": 
            case "java.lang.Long": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((Long)method.invoke(val, new Object[0])), 0, bytes, offset + idx, 8);
            }
            case "float": 
            case "java.lang.Float": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(((Float)method.invoke(val, new Object[0])).floatValue()), 0, bytes, offset + idx, 4);
            }
            case "double": 
            case "java.lang.Double": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((Double)method.invoke(val, new Object[0])), 0, bytes, offset + idx, 8);
            }
            case "byte[]": {
                return (bytes, idx, val) -> System.arraycopy(method.invoke(val, new Object[0]), 0, bytes, offset + idx, arrayLength);
            }
            case "java.lang.Byte[]": {
                return (bytes, idx, val) -> System.arraycopy(Converter.toPrimitive((Byte[])method.invoke(val, new Object[0])), 0, bytes, offset + idx, arrayLength);
            }
            case "short[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((short[])method.invoke(val, new Object[0])), 0, bytes, offset + idx, arrayLength * 2);
            }
            case "java.lang.Short[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toPrimitive((Short[])method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 2);
            }
            case "java.util.List<java.lang.Short>": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toShortArray((List)method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 2);
            }
            case "int[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((int[])method.invoke(val, new Object[0])), 0, bytes, offset + idx, arrayLength * 4);
            }
            case "java.lang.Integer[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toPrimitive((Integer[])method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 4);
            }
            case "java.util.List<java.lang.Integer>": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toIntArray((List)method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 4);
            }
            case "long[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((long[])method.invoke(val, new Object[0])), 0, bytes, offset + idx, arrayLength * 8);
            }
            case "java.lang.Long[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toPrimitive((Long[])method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 8);
            }
            case "java.util.List<java.lang.Long>": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toLongArray((List)method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 8);
            }
            case "float[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((float[])method.invoke(val, new Object[0])), 0, bytes, offset + idx, arrayLength * 4);
            }
            case "java.lang.Float[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toPrimitive((Float[])method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 4);
            }
            case "java.util.List<java.lang.Float>": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toFloatArray((List)method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 4);
            }
            case "double[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes((double[])method.invoke(val, new Object[0])), 0, bytes, offset + idx, arrayLength * 8);
            }
            case "java.lang.Double[]": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toPrimitive((Double[])method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 8);
            }
            case "java.util.List<java.lang.Double>": {
                return (bytes, idx, val) -> System.arraycopy(Bytes.toBytes(Converter.toDoubleArray((List)method.invoke(val, new Object[0]))), 0, bytes, offset + idx, arrayLength * 8);
            }
        }
        if (genericReturnTypeName.endsWith("[]")) {
            Class<?> componentType = returnTypeClass.getComponentType();
            if (componentType.getDeclaredAnnotation(FixedDataClass.class) != null) {
                FixedData fd = FixedData.getInstance(componentType);
                int size = fd.size();
                return (bytes, idx, val) -> {
                    for (int i = 0; i < arrayLength; ++i) {
                        fd.bindBytes(Array.get(method.invoke(val, new Object[0]), i), bytes, offset + idx + size * i);
                    }
                };
            }
        } else if (genericReturnTypeName.startsWith("java.util.List<")) {
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(genericReturnTypeName.substring(genericReturnTypeName.indexOf(60) + 1, genericReturnTypeName.lastIndexOf(62)));
                if (clazz.getDeclaredAnnotation(FixedDataClass.class) != null) {
                    FixedData fd = FixedData.getInstance(clazz);
                    int size = fd.size();
                    return (bytes, idx, val) -> {
                        List list = (List)List.class.cast(method.invoke(val, new Object[0]));
                        for (int i = 0; i < list.size(); ++i) {
                            fd.bindBytes(list.get(i), bytes, offset + idx + size * i);
                        }
                    };
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (returnTypeClass.getDeclaredAnnotation(FixedDataClass.class) != null) {
            FixedData fd = FixedData.getInstance(returnTypeClass);
            return (bytes, idx, val) -> fd.bindBytes(method.invoke(val, new Object[0]), bytes, offset + idx);
        }
        throw new IllegalArgumentException("does not support return type of " + genericReturnTypeName + " " + method.getName() + "() in " + this.parentClassName);
    }

    @Override
    public FixedMethodConsumer toClass(Method method) {
        int arrayLength = this.meta.arrayLength();
        int offset = this.meta.offset();
        Type genericParameterType = method.getGenericParameterTypes()[0];
        String genericParameterTypeName = genericParameterType.getTypeName();
        Class<?> parameterTypeClass = method.getParameterTypes()[0];
        switch (genericParameterTypeName) {
            case "byte": 
            case "java.lang.Byte": {
                return (bytes, idx, val) -> method.invoke(val, bytes[idx + offset]);
            }
            case "short": 
            case "java.lang.Short": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toShort(bytes, idx + offset));
            }
            case "int": 
            case "java.lang.Integer": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toInt(bytes, idx + offset));
            }
            case "long": 
            case "java.lang.Long": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toLong(bytes, idx + offset));
            }
            case "float": 
            case "java.lang.Float": {
                return (bytes, idx, val) -> method.invoke(val, Float.valueOf(Bytes.toFloat(bytes, idx + offset)));
            }
            case "double": 
            case "java.lang.Double": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toDouble(bytes, idx + offset));
            }
            case "byte[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Arrays.copyOfRange(bytes, idx + offset, idx + offset + arrayLength)});
            }
            case "java.lang.Byte[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Converter.toUnPrimitive(Arrays.copyOfRange(bytes, idx + offset, idx + offset + arrayLength))});
            }
            case "short[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Bytes.toShortArray(bytes, idx + offset, arrayLength)});
            }
            case "java.lang.Short[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Converter.toUnPrimitive(Bytes.toShortArray(bytes, idx + offset, arrayLength))});
            }
            case "java.util.List<java.lang.Short>": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toShortList(bytes, idx + offset, arrayLength));
            }
            case "int[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Bytes.toIntArray(bytes, idx + offset, arrayLength)});
            }
            case "java.lang.Integer[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Converter.toUnPrimitive(Bytes.toIntArray(bytes, idx + offset, arrayLength))});
            }
            case "java.util.List<java.lang.Integer>": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toIntegerList(bytes, idx + offset, arrayLength));
            }
            case "long[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Bytes.toLongArray(bytes, idx + offset, arrayLength)});
            }
            case "java.lang.Long[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Converter.toUnPrimitive(Bytes.toLongArray(bytes, idx + offset, arrayLength))});
            }
            case "java.util.List<java.lang.Long>": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toLongList(bytes, idx + offset, arrayLength));
            }
            case "float[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Bytes.toFloatArray(bytes, idx + offset, arrayLength)});
            }
            case "java.lang.Float[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Converter.toUnPrimitive(Bytes.toFloatArray(bytes, idx + offset, arrayLength))});
            }
            case "java.util.List<java.lang.Float>": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toFloatList(bytes, idx + offset, arrayLength));
            }
            case "double[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Bytes.toDoubleArray(bytes, idx + offset, arrayLength)});
            }
            case "java.lang.Double[]": {
                return (bytes, idx, val) -> method.invoke(val, new Object[]{Converter.toUnPrimitive(Bytes.toDoubleArray(bytes, idx + offset, arrayLength))});
            }
            case "java.util.List<java.lang.Double>": {
                return (bytes, idx, val) -> method.invoke(val, Bytes.toDoubleList(bytes, idx + offset, arrayLength));
            }
        }
        if (genericParameterTypeName.endsWith("[]")) {
            Class<?> componentType = parameterTypeClass.getComponentType();
            if (componentType.getDeclaredAnnotation(FixedDataClass.class) != null) {
                FixedData fd = FixedData.getInstance(componentType);
                int size = fd.size();
                return (bytes, idx, val) -> {
                    Object arr = Array.newInstance(componentType, arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        Array.set(arr, i, fd.toClass(bytes, idx + offset + size * i));
                    }
                    method.invoke(val, arr);
                };
            }
        } else if (genericParameterTypeName.startsWith("java.util.List<")) {
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(genericParameterTypeName.substring(genericParameterTypeName.indexOf(60) + 1, genericParameterTypeName.lastIndexOf(62)));
                if (clazz.getDeclaredAnnotation(FixedDataClass.class) != null) {
                    FixedData fd = FixedData.getInstance(clazz);
                    int size = fd.size();
                    return (bytes, idx, val) -> {
                        ArrayList list = new ArrayList();
                        for (int i = 0; i < arrayLength; ++i) {
                            list.add(fd.toClass(bytes, idx + offset + size * i));
                        }
                        method.invoke(val, list);
                    };
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (parameterTypeClass.getDeclaredAnnotation(FixedDataClass.class) != null) {
            FixedData fd = FixedData.getInstance(parameterTypeClass);
            return (bytes, idx, val) -> method.invoke(val, fd.toClass(bytes, idx + offset));
        }
        throw new IllegalArgumentException("does not support parameter type of void " + method.getName() + "(" + genericParameterTypeName + ") in the " + this.parentClassName);
    }
}

