/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes.fd;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import me.saro.commons.bytes.fd.FixedData;
import me.saro.commons.bytes.fd.FixedMethodConsumer;
import me.saro.commons.bytes.fd.FixedMethodUtils;
import me.saro.commons.bytes.fd.annotations.FixedDataClass;
import me.saro.commons.function.ThrowableConsumer;

public class FixedDataImpl
implements FixedData {
    final Class<?> clazz;
    final FixedDataClass fixedDataClassInfo;
    Constructor<?> constructor;
    List<FixedMethodConsumer> toBytesConsumers;
    List<FixedMethodConsumer> toClassConsumers;

    FixedDataImpl(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class must not null !!");
        }
        this.clazz = clazz;
        this.fixedDataClassInfo = clazz.getDeclaredAnnotation(FixedDataClass.class);
        this.init();
    }

    private void init() {
        if (this.fixedDataClassInfo == null) {
            throw new IllegalArgumentException(this.clazz.getName() + " is not defined @FixedDataClass");
        }
        for (Constructor<?> constructor : this.clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            this.constructor = constructor;
            break;
        }
        if (this.constructor == null) {
            throw new IllegalArgumentException(this.clazz.getName() + " does not have default Constructor");
        }
        Field[] fields = this.clazz.getDeclaredFields();
        this.toBytesConsumers = FixedMethodUtils.toBytesConsumers(this.fixedDataClassInfo, this.clazz, fields);
        this.toClassConsumers = FixedMethodUtils.toClassConsumers(this.fixedDataClassInfo, this.clazz, fields);
    }

    @Override
    public int size() {
        return this.fixedDataClassInfo.size();
    }

    @Override
    public byte[] bindBytes(Object data, byte[] out, int offset) {
        this.toBytesConsumers.parallelStream().forEach(ThrowableConsumer.runtime(e -> e.to(out, offset, data)));
        return out;
    }

    @Override
    public <T> T toClass(byte[] bytes, int offset) {
        Object t = this.constructor.newInstance(new Object[0]);
        this.toClassConsumers.parallelStream().forEach(ThrowableConsumer.runtime(e -> e.to(bytes, offset, t)));
        return (T)t;
    }
}

