/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ByteData {
    private static final byte[] BYTES_NEW_LINE = new byte[]{13, 10};
    byte[] buf;
    int size;
    final int capacity;
    final String charset;
    int writePointer;
    int readPointer;

    private ByteData(int capacity, String charset) {
        if (capacity < 10) {
            throw new IllegalArgumentException("capacity is must more then 10");
        }
        this.capacity = capacity;
        this.charset = charset;
        this.buf = new byte[this.capacity];
        this.size = this.buf.length;
        this.writePointer = 0;
        this.readPointer = 0;
    }

    public static ByteData create() {
        return new ByteData(8192, "UTF-8");
    }

    public static ByteData create(String charset) {
        return new ByteData(8192, charset);
    }

    public static ByteData create(int capacity, String charset) {
        return new ByteData(capacity, charset);
    }

    public ByteData write(byte[] data, int offset, int length) {
        this.allocate(this.writePointer + length);
        System.arraycopy(data, offset, this.buf, this.writePointer, length);
        this.writePointer += length;
        return this;
    }

    public ByteData write(byte[] data) {
        return this.write(data, 0, data.length);
    }

    public ByteData write(String data) throws IOException {
        return this.write(data.getBytes(this.charset));
    }

    public ByteData writeFixed(String data, int fixedSize, byte fill) throws IOException {
        byte[] bytes = this.toBytesWithCheckSize(data, fixedSize);
        return this.write(bytes).writeFill(fill, fixedSize - bytes.length);
    }

    public ByteData writeFixed(int data, int fixedSize, byte fill) throws IOException {
        return this.writeFixed(Integer.toString(data), fixedSize, fill);
    }

    public ByteData writeFixedAlignRight(String data, int fixedSize, byte fill) throws IOException {
        byte[] bytes = this.toBytesWithCheckSize(data, fixedSize);
        return this.writeFill(fill, fixedSize - bytes.length).write(bytes);
    }

    public ByteData writeFixedAlignRight(int data, int fixedSize, byte fill) throws IOException {
        return this.writeFixedAlignRight(Integer.toString(data), fixedSize, fill);
    }

    public ByteData write(InputStream is) throws IOException {
        int len;
        int bufsize = Math.max(8192, this.capacity);
        byte[] buf = new byte[bufsize];
        while ((len = is.read(buf)) >= 0) {
            this.write(buf, 0, len);
        }
        return this;
    }

    public ByteData write(InputStream is, int limit) throws IOException {
        int len;
        int bufsize = Math.max(8192, this.capacity);
        byte[] buf = new byte[bufsize];
        int sum = 0;
        while ((len = is.read(buf)) >= 0) {
            this.write(buf, 0, len);
            if ((sum += len) < limit) continue;
            break;
        }
        return this;
    }

    public ByteData write(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            ByteData byteData = this.write(fis);
            return byteData;
        }
    }

    public ByteData write(File file, String fileCharset) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);
             InputStreamReader isr = new InputStreamReader((InputStream)fis, fileCharset);){
            int len;
            int bufsize = Math.max(4096, this.capacity / 2);
            char[] buf = new char[bufsize];
            while ((len = isr.read(buf)) >= 0) {
                this.write(new String(buf, 0, len));
            }
        }
        return this;
    }

    public ByteData insert(byte[] data, int dataOffset, int dataLength, int offset) {
        this.allocate(offset + dataLength);
        System.arraycopy(data, dataOffset, this.buf, offset, dataLength);
        return this;
    }

    public ByteData insert(byte[] data, int offset) {
        return this.insert(data, 0, data.length, offset);
    }

    public ByteData insert(String data, int offset) throws IOException {
        return this.insert(data.getBytes(this.charset), offset);
    }

    public ByteData insertFixed(String data, int fixedSize, byte fill, int offset) throws IOException {
        byte[] bytes = this.toBytesWithCheckSize(data, fixedSize);
        return this.insert(bytes, offset).insertFill(fill, offset + bytes.length, fixedSize - bytes.length);
    }

    public ByteData insertFixedAlignRight(String data, int fixedSize, byte fill, int offset) throws IOException {
        byte[] bytes = this.toBytesWithCheckSize(data, fixedSize);
        int fillSize = fixedSize - bytes.length;
        return this.insertFill(fill, offset, fillSize).insert(bytes, fillSize + offset);
    }

    public ByteData insertFill(byte fill, int offset, int length) {
        if (length > 0) {
            this.allocate(offset + length);
            Arrays.fill(this.buf, offset, offset + length, fill);
        }
        return this;
    }

    public ByteData insertFillSpace(int offset, int length) {
        return this.insertFill((byte)32, offset, length);
    }

    public ByteData writeFill(byte fill, int length) {
        if (length == 0) {
            return this;
        }
        byte[] buf = new byte[length];
        Arrays.fill(buf, fill);
        return this.write(buf);
    }

    public ByteData writeFillSpace(int length) {
        return this.writeFill((byte)32, length);
    }

    public ByteData moveWritePointer(int index) {
        this.allocate(index);
        this.writePointer = index;
        return this;
    }

    public ByteData rectifyWritePointer() {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.buf[i] == 0) continue;
            this.writePointer = i + 1;
            return this;
        }
        this.writePointer = 0;
        return this;
    }

    public ByteData fillSpace() {
        for (int i = 0; i < this.writePointer; ++i) {
            if (this.buf[i] != 0) continue;
            this.buf[i] = 32;
        }
        return this;
    }

    public ByteData writeLine1() {
        return this.write(BYTES_NEW_LINE, 1, 1);
    }

    public ByteData writeLine2() {
        return this.write(BYTES_NEW_LINE, 0, 2);
    }

    public ByteData bind(OutputStream os) throws IOException {
        os.write(this.buf, 0, this.writePointer);
        os.flush();
        return this;
    }

    public ByteData bind(OutputStream os, int limit) throws IOException {
        os.write(this.buf, 0, Math.min(this.writePointer, limit));
        os.flush();
        return this;
    }

    public byte[] read(int size) throws IOException {
        if (this.readPointer + size > this.writePointer) {
            throw new IndexOutOfBoundsException("out of index : readPointer[" + (this.readPointer + size) + "], writePointer[" + this.writePointer + "]");
        }
        byte[] rv = Arrays.copyOfRange(this.buf, this.readPointer, this.readPointer + size);
        this.readPointer += size;
        return rv;
    }

    public String readText(int size, boolean isEmptyToNull) throws IOException {
        String text = new String(this.read(size), this.charset).replaceFirst("\\s+$", "");
        return isEmptyToNull && text.length() == 0 ? null : text;
    }

    public String readTextAlignRight(int size, boolean isEmptyToNull) throws IOException {
        String text = new String(this.read(size), this.charset).replaceFirst("^\\s+", "");
        return isEmptyToNull && text.length() == 0 ? null : text;
    }

    public int readTextInt(int size, int emptyDefaultValue) throws IOException {
        String text = new String(this.read(size), this.charset).trim();
        if (text.isEmpty()) {
            return emptyDefaultValue;
        }
        if ((text = text.replaceFirst("\\.0+$", "")).matches("0+")) {
            return 0;
        }
        return Integer.parseInt(text.replaceFirst("^0+", ""));
    }

    public long readTextLong(int size, long emptyDefaultValue) throws IOException {
        String text = new String(this.read(size), this.charset).trim();
        if (text.isEmpty()) {
            return emptyDefaultValue;
        }
        if ((text = text.replaceFirst("\\.0+$", "")).matches("0+")) {
            return 0L;
        }
        return Long.parseLong(text.replaceFirst("^0+", ""));
    }

    public ByteData readIgnore(int size) {
        this.readPointer += size;
        if (this.readPointer > this.writePointer) {
            throw new IndexOutOfBoundsException("out of index : readPointer[" + this.readPointer + "], writePointer[" + this.writePointer + "]");
        }
        return this;
    }

    public ByteData readIgnoreMatch(byte match) throws IOException {
        for (int i = this.readPointer; i < this.writePointer; ++i) {
            if (this.buf[i] != match) continue;
            this.readPointer = i + 1;
            return this;
        }
        throw new IOException("not found char[" + match + "]");
    }

    public ByteData readIgnoreCurrentLine() throws IOException {
        try {
            return this.readIgnoreMatch((byte)10);
        }
        catch (IOException e) {
            throw new IOException("not found new line (\\r\\n or \\n)");
        }
    }

    public ByteData newByteData(int offset, int length) {
        ByteData data = new ByteData(this.capacity, this.charset);
        return data.write(this.toBytes(offset, length));
    }

    public int size() {
        return this.writePointer;
    }

    public String toString() {
        return new String(this.buf, 0, this.writePointer, this.charset);
    }

    public byte[] toBytes() {
        return Arrays.copyOfRange(this.buf, 0, this.writePointer);
    }

    public byte[] toBytes(int offset, int length) {
        int end = offset + length;
        if (end > this.writePointer) {
            throw new IndexOutOfBoundsException("out of index : offset[" + offset + "], length[" + length + "], ByteDataSize[" + this.writePointer + "]");
        }
        return Arrays.copyOfRange(this.buf, offset, length);
    }

    private byte[] toBytesWithCheckSize(String data, int limit) {
        try {
            byte[] rv = data.getBytes(this.charset);
            if (rv.length > limit) {
                throw new IllegalArgumentException("data[" + this.charset + ":" + data + "] is over the limit[" + limit + "]");
            }
            return rv;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("cherset [" + this.charset + "] not support");
        }
    }

    private void allocate(int totalSize) {
        if (this.size < totalSize) {
            int allocate = (totalSize / this.capacity + 1) * this.capacity;
            this.buf = Arrays.copyOf(this.buf, allocate);
            this.size = allocate;
        }
    }
}

