/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public class Maps {
    public static <K, V> Map<K, V> toMap(Object ... entries) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        if (entries != null) {
            int len = entries.length;
            if (len % 2 == 1) {
                throw new IllegalArgumentException("parameter is (key1, val1, ... key[n], val[n])");
            }
            int i = 0;
            while (i < len) {
                Object k = entries[i++];
                Object v = entries[i++];
                map.put(k, v);
            }
        }
        return map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> pick(Map<K, V> map, K ... keys) {
        LinkedHashMap<K, V> rv = new LinkedHashMap<K, V>();
        if (keys != null) {
            for (K key : keys) {
                rv.put(key, map.get(key));
            }
        }
        return rv;
    }

    public static <K, V> Map<K, V> clone(Map<K, V> map) {
        LinkedHashMap<K, V> rv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            rv.put(entry.getKey(), entry.getValue());
        }
        return rv;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Predicate<Map.Entry<K, V>> filter) {
        LinkedHashMap<K, V> rv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.test(entry)) continue;
            rv.put(entry.getKey(), entry.getValue());
        }
        return rv;
    }
}

