/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateFormat {
    private static final Map<String, SimpleDateFormat> SDFM = new HashMap<String, SimpleDateFormat>();
    private final Calendar calendar;

    private DateFormat(long timeInMillis) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(timeInMillis);
    }

    private DateFormat(Calendar calendar) {
        this.calendar = calendar;
    }

    public static DateFormat now() {
        return new DateFormat(Calendar.getInstance());
    }

    public static DateFormat parse(Date date) {
        return new DateFormat(date.getTime());
    }

    public static DateFormat parse(long timeInMillis) {
        return new DateFormat(timeInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateFormat parse(String date, String format) {
        SimpleDateFormat sdf;
        Map<String, SimpleDateFormat> map = SDFM;
        synchronized (map) {
            sdf = SDFM.get(format);
            if (sdf == null) {
                sdf = new SimpleDateFormat(format);
                SDFM.put(format, sdf);
            }
        }
        try {
            return new DateFormat(((SimpleDateFormat)sdf.clone()).parse(date).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String format(String date, String oldFormat, String newFormat) {
        try {
            if (date != null && !date.isEmpty()) {
                return DateFormat.parse(date, oldFormat).toString(newFormat);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean valid(String date, String format) {
        try {
            if (date != null && format != null) {
                DateFormat df = DateFormat.parse(date, format);
                return df.toString(format).equals(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public DateFormat addMilliseconds(int milliseconds) {
        this.calendar.add(14, milliseconds);
        return this;
    }

    public DateFormat addMinutes(int minutes) {
        this.calendar.add(12, minutes);
        return this;
    }

    public DateFormat addHours(int hours) {
        this.calendar.add(10, hours);
        return this;
    }

    public DateFormat addDates(int date) {
        this.calendar.add(5, date);
        return this;
    }

    public DateFormat addMonth(int month) {
        this.calendar.add(2, month);
        return this;
    }

    public DateFormat addYear(int year) {
        this.calendar.add(1, year);
        return this;
    }

    public DateFormat setTimeInMillis(long timeInMillis) {
        this.calendar.setTimeInMillis(timeInMillis);
        return this;
    }

    public DateFormat setMilliseconds(int milliseconds) {
        this.calendar.set(14, milliseconds);
        return this;
    }

    public DateFormat setSeconds(int seconds) {
        this.calendar.set(13, seconds);
        return this;
    }

    public DateFormat setMinutes(int minutes) {
        this.calendar.set(12, minutes);
        return this;
    }

    public DateFormat setHours(int hours) {
        this.calendar.set(10, hours);
        return this;
    }

    public DateFormat setDate(int date) {
        this.calendar.set(5, date);
        return this;
    }

    public DateFormat setMonth(int month) {
        this.calendar.set(2, month);
        return this;
    }

    public DateFormat setYear(int year) {
        this.calendar.set(1, year);
        return this;
    }

    public long getTimeInMillis() {
        return this.calendar.getTimeInMillis();
    }

    public int getMilliseconds() {
        return this.calendar.get(14);
    }

    public int getSeconds() {
        return this.calendar.get(13);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getHours() {
        return this.calendar.get(10);
    }

    public int getDate() {
        return this.calendar.get(5);
    }

    public int getMonth() {
        return this.calendar.get(2);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public int getWeekOfMonth() {
        return this.calendar.get(4);
    }

    public int getWeekOfYear() {
        return this.calendar.get(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String format) {
        SimpleDateFormat sdf;
        Map<String, SimpleDateFormat> map = SDFM;
        synchronized (map) {
            sdf = SDFM.get(format);
            if (sdf == null) {
                sdf = new SimpleDateFormat(format);
                SDFM.put(format, sdf);
            }
        }
        return ((SimpleDateFormat)sdf.clone()).format(this.calendar.getTime());
    }

    public String toString(String format) {
        return this.format(format);
    }

    public String toString() {
        return this.toISO8601();
    }

    public String toISO8601() {
        String format = this.format("yyyy-MM-dd'T'HH:mm:ssZ");
        return format.lastIndexOf(43) != format.length() - 5 ? format.replaceFirst("([\\d]{2})$", ":$1") : format;
    }

    public Date toDate() {
        return this.calendar.getTime();
    }

    public DateFormat clone() {
        return new DateFormat((Calendar)this.calendar.clone());
    }

    public Calendar toCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().getName().equals(obj.getClass().getName())) {
            return this.getTimeInMillis() == ((DateFormat)obj).getTimeInMillis();
        }
        return false;
    }
}

