/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.json;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.saro.commons.Converter;

public class JsonReader {
    Boolean lock = true;
    Object data;

    public JsonReader(Object data) {
        this.data = data;
    }

    public JsonReader(String json) {
        Map<String, Object> data;
        int arrayIndex = json.indexOf(91);
        int objectIndex = json.indexOf(123);
        this.data = data = arrayIndex > -1 && (arrayIndex < objectIndex || objectIndex == -1) ? Converter.toMapListByJsonArray(json) : Converter.toMapByJsonObject(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isArray() {
        boolean rv;
        Boolean bl = this.lock;
        synchronized (bl) {
            rv = List.class.isAssignableFrom(this.data.getClass());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isObject() {
        boolean rv;
        Boolean bl = this.lock;
        synchronized (bl) {
            rv = Map.class.isAssignableFrom(this.data.getClass());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        if (this.isArray()) {
            int rv;
            Boolean bl = this.lock;
            synchronized (bl) {
                rv = this.list().size();
            }
            return rv;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JsonReader> toList() {
        List<JsonReader> rv;
        Boolean bl = this.lock;
        synchronized (bl) {
            rv = List.class.isAssignableFrom(this.data.getClass()) ? this.list().stream().map(e -> new JsonReader(e)).collect(Collectors.toList()) : null;
        }
        if (rv == null) {
            throw new RuntimeException("is not list");
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonReader get(int index) {
        Map<String, Object> rv;
        Boolean bl = this.lock;
        synchronized (bl) {
            rv = List.class.isAssignableFrom(this.data.getClass()) ? this.list().get(index) : null;
        }
        if (rv == null) {
            throw new RuntimeException("is not list");
        }
        return new JsonReader(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name) {
        Object rv;
        boolean isNotObject = false;
        Boolean bl = this.lock;
        synchronized (bl) {
            if (Map.class.isAssignableFrom(this.data.getClass())) {
                rv = this.map().get(name);
                if (rv != null && (List.class.isAssignableFrom(rv.getClass()) || Map.class.isAssignableFrom(rv.getClass()))) {
                    rv = new JsonReader(rv);
                }
            } else {
                rv = null;
                isNotObject = true;
            }
        }
        if (isNotObject) {
            throw new RuntimeException("is not object");
        }
        return rv;
    }

    public String getString(String name) {
        Object rv = this.get(name);
        return rv != null ? rv.toString() : null;
    }

    public int getInt(String name, int defaultValue) {
        Object rv = this.get(name);
        try {
            return rv != null ? Integer.parseInt(rv.toString()) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonReader into(String name) {
        Object rv;
        Boolean bl = this.lock;
        synchronized (bl) {
            rv = this.map().get(name);
        }
        return new JsonReader(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String rv;
        Boolean bl = this.lock;
        synchronized (bl) {
            rv = Converter.toJson(this.data);
        }
        return rv;
    }

    protected Object clone() {
        return new JsonReader(this.data);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().getName().equals(this.getClass().getName()) && this.toString().equals(obj.toString());
    }

    private List<Map<String, Object>> list() {
        return (List)this.data;
    }

    private Map<String, Object> map() {
        return (Map)this.data;
    }
}

