/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.excel;

import me.saro.commons.excel.Excel;
import me.saro.commons.excel.ExcelCell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRow {
    final Excel excel;
    final int rowIndex;
    private int cellIndex = -1;
    private Row pRow;
    ExcelCell cell;

    ExcelRow(Excel excel, int rowIndex) {
        this.excel = excel;
        this.rowIndex = rowIndex;
    }

    public ExcelRow getNextRow() {
        return new ExcelRow(this.excel, this.rowIndex + 1);
    }

    public ExcelRow moveNextCell() {
        this.cell = new ExcelCell(this, ++this.cellIndex);
        return this;
    }

    public ExcelCell getCell() {
        return this.cell;
    }

    public ExcelCell getCell(int cellIndex) {
        return new ExcelCell(this, cellIndex);
    }

    public boolean isEmpty() {
        return this.getPoiRow(false) == null;
    }

    public Row getPoiRow(boolean force) {
        if (this.pRow == null) {
            this.pRow = this.excel.getPoiSheet().getRow(this.rowIndex);
            if (this.pRow == null && force) {
                this.pRow = this.excel.getPoiSheet().createRow(this.rowIndex);
            }
        }
        return this.pRow;
    }

    public static int toRowIndex(String rowColumnName) {
        return Integer.parseInt(rowColumnName) - 1;
    }

    public static String toColumnNameByRowIndex(int rowIndex) {
        return Integer.toString(rowIndex + 1);
    }
}

