/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.saro.commons.bytes.AbstractDataFormat;
import me.saro.commons.bytes.Bytes;
import me.saro.commons.bytes.annotations.FixedBinary;
import me.saro.commons.bytes.annotations.FixedData;
import me.saro.commons.bytes.annotations.FixedText;
import me.saro.commons.bytes.annotations.FixedTextAlign;
import me.saro.commons.function.ThrowableConsumer;
import me.saro.commons.function.ThrowableSupplier;

public class FixedDataFormat<T>
extends AbstractDataFormat {
    final Class<T> clazz;
    final FixedData fixedData;
    final Supplier<T> newInstance;
    final List<FixedDataBytesToClass> toClassOrders = Collections.synchronizedList(new ArrayList());
    final List<FixedDataClassToBytes> toBytesOrders = Collections.synchronizedList(new ArrayList());

    FixedDataFormat(Class<T> clazz, Supplier<T> newInstance) {
        this.clazz = clazz;
        this.fixedData = clazz.getDeclaredAnnotation(FixedData.class);
        this.newInstance = newInstance;
        this.init();
    }

    public static <T> FixedDataFormat<T> create(Class<T> clazz, Supplier<T> newInstance) {
        return new FixedDataFormat<T>(clazz, newInstance);
    }

    public static <T> FixedDataFormat<T> create(Class<T> clazz) {
        return FixedDataFormat.create(clazz, ThrowableSupplier.runtime(() -> clazz.getDeclaredConstructors()[0].newInstance(new Object[0])));
    }

    public T toClass(byte[] bytes, int offset) {
        Object t = this.newInstance.get();
        this.toClassOrders.parallelStream().forEach(ThrowableConsumer.runtime(e -> e.order(t, bytes, offset)));
        return t;
    }

    public T toClass(byte[] bytes) {
        return this.toClass(bytes, 0);
    }

    public T toClassWithCheckSize(byte[] bytes) {
        if (bytes.length != this.fixedData.size()) {
            throw new IllegalArgumentException("size not matched define[" + this.fixedData.size() + "] data[]" + bytes.length + "");
        }
        return this.toClass(bytes, 0);
    }

    public T toClassWithCheckSize(String line) {
        return this.toClassWithCheckSize(line, this.fixedData.charset());
    }

    public T toClassWithCheckSize(String line, String charset) {
        try {
            return this.toClassWithCheckSize(line.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void bindBytes(byte[] outputBytes, int offset, T obj) {
        Arrays.fill(outputBytes, offset, offset + this.fixedData.size(), this.fixedData.fill());
        this.toBytesOrders.parallelStream().forEach(ThrowableConsumer.runtime(e -> e.order(obj, outputBytes, offset)));
    }

    public void bindBytes(OutputStream out, T obj) throws IOException {
        byte[] buf = new byte[this.fixedData.size()];
        this.bindBytes(buf, 0, obj);
        out.write(buf);
    }

    public byte[] toBytes(T obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.bindBytes(baos, obj);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (this.fixedData == null) {
            throw new IllegalArgumentException(this.clazz.getName() + " need to Declared @FixedData Annotation");
        }
        if (this.fixedData.size() < 1) {
            throw new IllegalArgumentException(this.clazz.getName() + " need to Declared size");
        }
        boolean infGetter = this.fixedData.ignoreNotFoundGetter();
        boolean infSetter = this.fixedData.ignoreNotFoundSetter();
        ((Stream)Stream.of(this.clazz.getDeclaredFields()).parallel()).forEach(ThrowableConsumer.runtime(field -> {
            FixedBinary binary = field.getDeclaredAnnotation(FixedBinary.class);
            FixedText text = field.getDeclaredAnnotation(FixedText.class);
            if (binary != null) {
                this.setter(this.clazz, field.getName(), infSetter).ifPresent(e -> this.bindToClassOrder((Method)e, binary));
                this.getter(this.clazz, field.getName(), infGetter).ifPresent(e -> this.bindToBytesOrder((Method)e, binary));
            } else if (text != null) {
                this.setter(this.clazz, field.getName(), infSetter).ifPresent(e -> this.bindToClassOrder((Method)e, text));
                this.getter(this.clazz, field.getName(), infGetter).ifPresent(e -> this.bindToBytesOrder((Method)e, text));
            }
        }));
    }

    private void bindToBytesOrder(Method method, FixedBinary da) {
        int dfOffset = da.offset();
        int arrayLength = da.arrayLength();
        String type = method.getReturnType().getName();
        this.toBytesOrders.add((clazz, bytes, offset) -> {
            int s = offset + dfOffset;
            Object val = method.invoke(clazz, new Object[0]);
            if (val == null) {
                return;
            }
            switch (type) {
                case "[B": 
                case "[Ljava.lang.Byte;": {
                    System.arraycopy(val, 0, bytes, s, arrayLength);
                    return;
                }
                case "byte": 
                case "java.lang.Byte": {
                    bytes[s] = (Byte)val;
                    return;
                }
                case "short": 
                case "java.lang.Short": {
                    System.arraycopy(Bytes.toBytes((Short)val), 0, bytes, s, 2);
                    return;
                }
                case "int": 
                case "java.lang.Integer": {
                    System.arraycopy(Bytes.toBytes((Integer)val), 0, bytes, s, 4);
                    return;
                }
                case "long": 
                case "java.lang.Long": {
                    System.arraycopy(Bytes.toBytes((Long)val), 0, bytes, s, 8);
                    return;
                }
                case "float": 
                case "java.lang.Float": {
                    System.arraycopy(Bytes.toBytes(((Float)val).floatValue()), 0, bytes, s, 4);
                    return;
                }
                case "double": 
                case "java.lang.Double": {
                    System.arraycopy(Bytes.toBytes((Double)val), 0, bytes, s, 8);
                    return;
                }
            }
            throw new IllegalArgumentException("type [" + type + "] does not support");
        });
    }

    private void bindToBytesOrder(Method method, FixedText da) {
        int dfOffset = da.offset();
        int dfLength = da.length();
        boolean isLeft = da.align() == FixedTextAlign.left;
        String type = method.getReturnType().getName();
        boolean unsigned = da.unsigned();
        String charset = "".equals(da.charset()) ? this.fixedData.charset() : da.charset();
        int radix = da.radix();
        this.toBytesOrders.add((clazz, bytes, offset) -> {
            int e;
            byte[] vbytes;
            int s;
            byte fill = da.fill();
            Object val = method.invoke(clazz, new Object[0]);
            if (val == null) {
                int e2 = s + dfLength;
                for (s = offset + dfOffset; s < e2; ++s) {
                    bytes[s] = fill;
                }
                return;
            }
            switch (type) {
                case "java.lang.String": {
                    vbytes = ((String)val).getBytes(charset);
                    break;
                }
                case "byte": 
                case "java.lang.Byte": {
                    vbytes = Integer.toString(unsigned ? Byte.toUnsignedInt((Byte)val) : (Byte)val, radix).getBytes();
                    break;
                }
                case "short": 
                case "java.lang.Short": {
                    vbytes = Integer.toString(unsigned ? Short.toUnsignedInt((Short)val) : (Short)val, radix).getBytes();
                    break;
                }
                case "int": 
                case "java.lang.Integer": {
                    vbytes = (unsigned ? Integer.toUnsignedString((Integer)val, radix) : Integer.toString((Integer)val, radix)).getBytes();
                    break;
                }
                case "long": 
                case "java.lang.Long": {
                    vbytes = (unsigned ? Long.toUnsignedString((Long)val, radix) : Long.toString((Long)val, radix)).getBytes();
                    break;
                }
                case "float": 
                case "java.lang.Float": {
                    vbytes = Float.toString(((Float)val).floatValue()).getBytes();
                    break;
                }
                case "double": 
                case "java.lang.Double": {
                    vbytes = Double.toString((Double)val).getBytes();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("type [" + type + "] does not support");
                }
            }
            int vLen = vbytes.length;
            if (vLen > dfLength) {
                throw new IllegalArgumentException("[" + new String(vbytes, charset) + "] is out of range of " + method.getName() + "()");
            }
            if (isLeft) {
                System.arraycopy(vbytes, 0, bytes, s, vLen);
                e = s + dfLength;
                for (int i = s + vLen; i < e; ++i) {
                    bytes[i] = fill;
                }
            } else {
                e = s + (dfLength - vLen);
                while (s < e) {
                    bytes[s] = fill;
                    ++s;
                }
                System.arraycopy(vbytes, 0, bytes, s, vLen);
            }
        });
    }

    private void bindToClassOrder(Method method, FixedBinary da) {
        int dfOffset = da.offset();
        int arrayLength = da.arrayLength();
        String type = method.getParameterTypes()[0].getName();
        if (type.startsWith("[") && arrayLength < 1) {
            throw new IllegalArgumentException("arrayLength must over then 1");
        }
        this.toClassOrders.add((obj, bytes, offset) -> {
            int s = offset + dfOffset;
            switch (type) {
                case "[B": 
                case "[Ljava.lang.Byte;": {
                    method.invoke(obj, new Object[]{Arrays.copyOfRange(bytes, s, s + arrayLength)});
                    return;
                }
                case "byte": 
                case "java.lang.Byte": {
                    method.invoke(obj, bytes[s]);
                    return;
                }
                case "short": 
                case "java.lang.Short": {
                    method.invoke(obj, Bytes.toShort(bytes, s));
                    return;
                }
                case "int": 
                case "java.lang.Integer": {
                    method.invoke(obj, Bytes.toInt(bytes, s));
                    return;
                }
                case "long": 
                case "java.lang.Long": {
                    method.invoke(obj, Bytes.toLong(bytes, s));
                    return;
                }
                case "float": 
                case "java.lang.Float": {
                    method.invoke(obj, Float.valueOf(Bytes.toFloat(bytes, s)));
                    return;
                }
                case "double": 
                case "java.lang.Double": {
                    method.invoke(obj, Bytes.toDouble(bytes, s));
                    return;
                }
            }
            throw new IllegalArgumentException("type [" + type + "] does not support");
        });
    }

    private void bindToClassOrder(Method method, FixedText da) {
        if (method.getParameterCount() != 1) {
            return;
        }
        int dfOffset = da.offset();
        int dfLength = da.length();
        byte dfFill = da.fill();
        boolean isLeft = da.align() == FixedTextAlign.left;
        String type = method.getParameterTypes()[0].getName();
        boolean unsigned = da.unsigned();
        String charset = "".equals(da.charset()) ? this.fixedData.charset() : da.charset();
        int radix = da.radix();
        if (dfLength < 1) {
            throw new IllegalArgumentException("length must over then 1");
        }
        this.toClassOrders.add((obj, bytes, offset) -> {
            String val;
            block29: {
                int s;
                int e = s + dfLength;
                byte fill = dfFill;
                if (isLeft) {
                    while (s < e) {
                        if (bytes[--e] == fill) continue;
                        val = new String(bytes, s, e - s + 1, charset);
                        break block29;
                    }
                    val = "";
                } else {
                    for (s = offset + dfOffset; s < e; ++s) {
                        if (bytes[s] == fill) continue;
                        val = new String(bytes, s, e - s, charset);
                        break block29;
                    }
                    val = "";
                }
            }
            if (!"java.lang.String".equals(type)) {
                try {
                    switch (type) {
                        case "byte": 
                        case "java.lang.Byte": {
                            method.invoke(obj, (byte)Integer.parseInt(val, radix));
                            return;
                        }
                        case "short": 
                        case "java.lang.Short": {
                            method.invoke(obj, (short)Integer.parseInt(val, radix));
                            return;
                        }
                        case "int": 
                        case "java.lang.Integer": {
                            method.invoke(obj, unsigned ? (int)Long.parseLong(val, radix) : Integer.parseInt(val, radix));
                            return;
                        }
                        case "long": 
                        case "java.lang.Long": {
                            method.invoke(obj, unsigned ? Long.parseUnsignedLong(val, radix) : Long.parseLong(val, radix));
                            return;
                        }
                        case "float": 
                        case "java.lang.Float": {
                            method.invoke(obj, Float.valueOf(Float.parseFloat(val)));
                            return;
                        }
                        case "double": 
                        case "java.lang.Double": {
                            method.invoke(obj, Double.parseDouble(val));
                            return;
                        }
                    }
                    throw new IllegalArgumentException("type [" + type + "] does not support");
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("[" + val + "] is not [" + type + "] in " + this.clazz.getName() + "." + method.getName() + "()");
                }
            }
            method.invoke(obj, val);
        });
    }

    @FunctionalInterface
    private static interface FixedDataClassToBytes {
        public void order(Object var1, byte[] var2, int var3) throws Exception;
    }

    @FunctionalInterface
    private static interface FixedDataBytesToClass {
        public void order(Object var1, byte[] var2, int var3) throws Exception;
    }
}

