/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.bytes;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.stream.IntStream;

public class Bytes {
    static final Base64.Encoder EN_BASE64 = Base64.getEncoder();
    static final Base64.Decoder DE_BASE64 = Base64.getDecoder();
    static final char[][] BYTE_TO_HEX_STR_MAP = (char[][])IntStream.range(0, 256).boxed().map(i -> String.format("%02x", i).toCharArray()).toArray(x$0 -> new char[x$0][]);

    private Bytes() {
    }

    public static String toHex(byte[] bytes) {
        StringBuilder rv = new StringBuilder(bytes.length * 2 + 10);
        for (byte b : bytes) {
            rv.append(BYTE_TO_HEX_STR_MAP[b & 0xFF]);
        }
        return rv.toString();
    }

    public static byte[] toBytesByHex(String hex) {
        byte[] rv = new byte[hex.length() / 2];
        int rvp = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            rv[rvp++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return rv;
    }

    public static String encodeBase64String(byte[] data) {
        return EN_BASE64.encodeToString(data);
    }

    public static String encodeBase64String(String text, String charset) {
        return EN_BASE64.encodeToString(text.getBytes(charset));
    }

    public static byte[] decodeBase64(String base64) {
        return DE_BASE64.decode(base64);
    }

    public static String decodeBase64(String base64, String charset) {
        return new String(DE_BASE64.decode(base64), charset);
    }

    public static byte[] toBytes(short val) {
        return ByteBuffer.allocate(2).putShort(val).array();
    }

    public static byte[] toBytes(int val) {
        return ByteBuffer.allocate(4).putInt(val).array();
    }

    public static byte[] toBytes(long val) {
        return ByteBuffer.allocate(8).putLong(val).array();
    }

    public static byte[] toBytes(float val) {
        return ByteBuffer.allocate(4).putFloat(val).array();
    }

    public static byte[] toBytes(double val) {
        return ByteBuffer.allocate(8).putDouble(val).array();
    }

    public static short toShort(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 2).getShort();
    }

    public static short toShort(byte[] val) {
        return ByteBuffer.wrap(val, 0, 2).getShort();
    }

    public static int toInt(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 4).getInt();
    }

    public static int toInt(byte[] val) {
        return ByteBuffer.wrap(val, 0, 4).getInt();
    }

    public static long toLong(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 8).getLong();
    }

    public static long toLong(byte[] val) {
        return ByteBuffer.wrap(val, 0, 8).getLong();
    }

    public static float toFloat(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 4).getFloat();
    }

    public static float toFloat(byte[] val) {
        return ByteBuffer.wrap(val, 0, 4).getFloat();
    }

    public static double toDouble(byte[] val, int offset) {
        return ByteBuffer.wrap(val, offset, 8).getDouble();
    }

    public static double toDouble(byte[] val) {
        return ByteBuffer.wrap(val, 0, 8).getDouble();
    }
}

