/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.saro.commons.function.ThrowableTriConsumer;
import me.saro.commons.web.BasicWeb;
import me.saro.commons.web.WebResult;

public class Zips {
    private Zips() {
    }

    public static void openStreamNotClose(InputStream inputStream, ThrowableTriConsumer<String, ZipEntry, InputStream> callbackFileInputstream) throws Exception {
        ZipEntry ze;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((ze = zipInputStream.getNextEntry()) != null) {
            if (!ze.isDirectory()) {
                callbackFileInputstream.accept(ze.getName(), ze, zipInputStream);
            }
            zipInputStream.closeEntry();
        }
    }

    public static void openFromFile(File zipfile, ThrowableTriConsumer<String, ZipEntry, InputStream> callbackFileInputstream) throws Exception {
        try (FileInputStream is = new FileInputStream(zipfile);){
            Zips.openStreamNotClose(is, callbackFileInputstream);
        }
    }

    public static void openFromWeb(BasicWeb web, ThrowableTriConsumer<String, ZipEntry, InputStream> callbackFileInputstream) throws Exception {
        WebResult<String> res = web.readRawResultStream(is -> Zips.openStreamNotClose(is, callbackFileInputstream));
        if (res.getException() != null) {
            throw res.getException();
        }
    }
}

