/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import me.saro.commons.DateFormat;

public class Valids {
    public static final String IS_MAIL = "[_a-z0-9\\-]+(\\.[_a-z0-9\\-])*@([_a-z0-9\\-]+\\.)+[a-z]{2,}";

    private Valids() {
    }

    public static boolean isMail(String mail, int maxLength) {
        return mail != null && mail.length() <= maxLength && mail.matches(IS_MAIL);
    }

    public static boolean isNotNull(Object ... objs) {
        if (objs != null) {
            for (Object obj : objs) {
                if (obj != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isNotBlank(String ... texts) {
        if (texts != null) {
            for (String text : texts) {
                if (text != null && !text.matches("[\\s]*")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isDate(String date, String format) {
        try {
            return date.equals(DateFormat.parse(date, format).toString(format));
        }
        catch (Exception e) {
            return false;
        }
    }
}

