/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.saro.commons.function.StreamReadConsumer;
import me.saro.commons.function.ThrowableConsumer;
import me.saro.commons.function.ThrowableFunction;
import me.saro.commons.function.ThrowableRunnable;

public class Utils {
    static final long TIME_MILLIS_UNIT_DAY = 86400000L;
    static final char[] BASE62_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();

    private Utils() {
    }

    @SafeVarargs
    public static <T> T nvl(T ... list) {
        for (T t : list) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static String evl(String ... list) {
        for (String val : list) {
            if (val == null || val.isEmpty()) continue;
            return val;
        }
        return null;
    }

    public static String bvl(String ... list) {
        for (String val : list) {
            if (val == null || val.matches("[\\s]*")) continue;
            return val;
        }
        return null;
    }

    public static boolean blank(String val) {
        return val == null || val.matches("[\\s]*");
    }

    public static String zerofill(String number, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must more then 1");
        }
        if (!number.matches("[\\d]+")) {
            throw new IllegalArgumentException("number must unsigned integer([0-9]+)");
        }
        int needFillSize = length - number.length();
        if (needFillSize == 0) {
            return number;
        }
        if (needFillSize > 0) {
            char[] fills = new char[needFillSize];
            Arrays.fill(fills, '0');
            return new String(fills) + number;
        }
        throw new IllegalArgumentException("[" + number + "] is over length then " + length);
    }

    public static String zerofill(long val, int length) {
        return Utils.zerofill(Long.toString(val), length);
    }

    public static String zerofill(int val, int length) {
        return Utils.zerofill(Integer.toString(val), length);
    }

    public static String norNumber(String number) {
        String no = number.trim().replace(",", "").replaceFirst("\\.[0]+", "");
        boolean m = false;
        switch (no.charAt(0)) {
            case '-': {
                m = true;
            }
            case '+': {
                no = no.substring(1);
            }
        }
        int zeroIndex = 0;
        for (char ch : no.toCharArray()) {
            if (ch != '0') break;
            ++zeroIndex;
        }
        return (m ? "-" : "") + (zeroIndex == 0 ? no : no.substring(zeroIndex));
    }

    public static double parseDouble(String doubleValue) {
        return Double.parseDouble(Utils.norNumber(doubleValue));
    }

    public static long parseLong(String longValue) {
        return Long.parseLong(Utils.norNumber(longValue));
    }

    public static void linkStream(InputStream is, OutputStream os) throws IOException {
        int len;
        int bufsize = 8192;
        byte[] buf = new byte[bufsize];
        while ((len = is.read(buf, 0, bufsize)) != -1) {
            os.write(buf, 0, len);
        }
        os.flush();
    }

    public static String createRandomString(char[] mold, int len) {
        char[] rv = new char[len];
        int charLen = mold.length;
        for (int i = 0; i < len; ++i) {
            rv[i] = mold[(int)(Math.random() * (double)charLen)];
        }
        return new String(rv);
    }

    public static String createRandomString(char[] mold, int min, int max) {
        return Utils.createRandomString(mold, (int)Utils.random(min, max));
    }

    public static String createRandomBase62String(int min, int max) {
        return Utils.createRandomString(BASE62_CHARS, (int)Utils.random(min, max));
    }

    public static long random(long min, long max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            throw new IllegalArgumentException("'lessThen' have to over the value then 'min'");
        }
        return min + (long)((int)(Math.random() * (double)(max + 1L - min)));
    }

    public static void inputStreamReader(InputStream inputStream, StreamReadConsumer callback) throws Exception {
        int len;
        int size = Math.min(inputStream.available(), 8192);
        byte[] buf = new byte[size];
        while ((len = inputStream.read(buf, 0, size)) != -1) {
            callback.accept(buf, len);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T inputStreamLineReader(InputStream inputStream, String charset, ThrowableFunction<Stream<String>, T> lineReader) throws Exception {
        try (InputStreamReader isr = new InputStreamReader(inputStream, charset);){
            Stream<String> stream;
            try (BufferedReader br = new BufferedReader(isr);){
                stream = lineReader.apply(br.lines());
            }
            return (T)stream;
        }
    }

    public static <T, R> List<R> executeAllThreads(ExecutorService executorService, List<T> list, ThrowableFunction<T, R> map) {
        try {
            return executorService.invokeAll(list.parallelStream().map(e -> () -> map.apply(e)).collect(Collectors.toList())).parallelStream().map(ThrowableFunction.runtime(x -> x.get())).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static <T, R> List<R> executeAllThreads(int nThreads, List<T> list, ThrowableFunction<T, R> map) {
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        List<R> rv = Utils.executeAllThreads(executorService, list, map);
        executorService.shutdown();
        return rv;
    }

    public static void kill(Closeable closeable) {
        if (closeable != null) {
            try {
                Closeable tmp = closeable;
                if (tmp != null) {
                    tmp.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void kill(Thread thread) {
        if (thread != null) {
            try {
                if (thread.isInterrupted()) {
                    thread.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static TimerTask timerTask(final ThrowableConsumer<TimerTask> task) {
        return new TimerTask(){

            @Override
            public void run() {
                task.accept(this);
            }
        };
    }

    public static long timestamp(ThrowableRunnable runnable) {
        long ts = System.currentTimeMillis();
        try {
            runnable.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ts = System.currentTimeMillis() - ts;
        System.out.println("timestamp : " + ts);
        return ts;
    }
}

