/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.saro.commons.Utils;
import me.saro.commons.function.ThrowableFunction;
import me.saro.commons.function.ThrowablePredicate;

public class Files {
    private Files() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createFile(File file, boolean overwrite, InputStream inputStream) throws Exception {
        if (file.exists()) {
            if (!overwrite) throw new IOException("create file error : already exists file : " + file.getAbsolutePath());
            file.delete();
        } else {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            } else if (parent.isFile()) {
                throw new IOException("create file error : file exists instend of the directory : " + parent.getAbsolutePath());
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             InputStream is = inputStream;){
            Utils.inputStreamReader(is, (buf, len) -> fos.write(buf, 0, len));
            return;
        }
    }

    public static void createFile(File file, boolean overwrite, String value, String charset) throws Exception {
        Files.createFile(file, overwrite, new ByteArrayInputStream(value.getBytes(charset)));
    }

    public static Stream<File> listFilesStream(File directory) {
        return Stream.of(directory.listFiles());
    }

    public static Stream<File> listFilesStream(String directory) {
        return Stream.of(new File(directory).listFiles());
    }

    public static <T> T lineReader(File file, String charset, ThrowableFunction<Stream<String>, T> lineReader) throws Exception {
        T t = null;
        try (FileInputStream fis = new FileInputStream(file);){
            t = Utils.inputStreamLineReader(fis, charset, lineReader);
        }
        return t;
    }

    public static <T> T lineReader(String file, String charset, ThrowableFunction<Stream<String>, T> lineReader) throws Exception {
        return Files.lineReader(new File(file), charset, lineReader);
    }

    public static String toFileExt(File filename) {
        String name = filename.getName().toLowerCase();
        int pos = name.lastIndexOf(46);
        return pos != -1 ? name.substring(pos + 1) : "";
    }

    public static String toFileExt(String filename) {
        String name = filename.toLowerCase().replace('\\', '/');
        int pos = name.lastIndexOf(47);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        return (pos = name.lastIndexOf(46)) != -1 ? name.substring(pos + 1) : "";
    }

    public static boolean validFileExt(File filename, String ... fileExts) {
        if (fileExts == null || fileExts.length == 0) {
            throw new IllegalArgumentException("At least one fileExts argument is required.");
        }
        String ext = Files.toFileExt(filename);
        for (String fileExt : fileExts) {
            if (!fileExt.equals(ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean validFileExt(String filename, String ... fileExts) {
        if (fileExts == null || fileExts.length == 0) {
            throw new IllegalArgumentException("At least one fileExts argument is required.");
        }
        String ext = Files.toFileExt(filename);
        for (String fileExt : fileExts) {
            if (!fileExt.equals(ext)) continue;
            return true;
        }
        return false;
    }

    public static BasicFileAttributes toBasicFileAttributes(File file) throws IOException {
        return java.nio.file.Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
    }

    public static Predicate<File> attributesFilter(ThrowablePredicate<BasicFileAttributes> filter) {
        return ThrowablePredicate.runtime(e -> filter.test(Files.toBasicFileAttributes(e)));
    }
}

