/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.saro.commons.Maps;
import me.saro.commons.bytes.Bytes;
import me.saro.commons.converter.HashAlgorithm;
import me.saro.commons.function.ThrowableBiFunction;
import me.saro.commons.function.ThrowableFunction;

public class Converter {
    static final int BUFSIZE = 4096;
    static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};
    static final TypeReference<List<Map<String, Object>>> JSON_MAP_LIST = new TypeReference<List<Map<String, Object>>>(){};

    private Converter() {
    }

    public static String[] splitCsvLine(String line) {
        if (line == null) {
            return new String[0];
        }
        String[] rv = line.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
        for (int i = 0; i < rv.length; ++i) {
            String tmp = rv[i];
            if (tmp.indexOf(34) != 0) continue;
            rv[i] = tmp.substring(1, Math.max(tmp.length() - 1, 1));
        }
        return rv;
    }

    public static List<String> splitByToken(String data, String token) {
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        int tokenSize = token.length();
        int offset = 0;
        int pnt = data.indexOf(token);
        if (tokenSize < 1) {
            throw new RuntimeException("token is empty");
        }
        if (pnt == -1) {
            list.add(data);
            return list;
        }
        for (int i = 0; i < 99999; ++i) {
            list.add(data.substring(offset, pnt));
            offset = pnt + tokenSize;
            pnt = data.indexOf(token, offset);
            if (pnt != -1) continue;
            list.add(data.substring(offset));
            return list;
        }
        throw new RuntimeException("splitByToken support less then 99999 tokens per data");
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... args) {
        ArrayList<T> list = new ArrayList<T>();
        if (args != null) {
            for (T t : args) {
                list.add(t);
            }
        }
        return list;
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(InputStream is, int bufferSize) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
        byte[] buf = new byte[bufferSize];
        while ((len = is.read(buf, 0, bufferSize)) > 0) {
            baos.write(buf, 0, len);
        }
        return baos;
    }

    public static byte[] toBytes(InputStream is, int bufferSize) throws IOException {
        return Converter.toByteArrayOutputStream(is, bufferSize).toByteArray();
    }

    public static <T> T toClassByJson(String json, TypeReference<T> typeReference) {
        try {
            return (T)(json != null ? JSON_MAPPER.readValue(json, typeReference) : null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> toMapByJsonObject(String jsonObject) {
        try {
            return jsonObject != null ? (Map)JSON_MAPPER.readValue(jsonObject, JSON_MAP) : Collections.emptyMap();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<String, Object>> toMapListByJsonArray(String jsonArray) {
        try {
            return jsonArray != null ? (List)JSON_MAPPER.readValue(jsonArray, JSON_MAP_LIST) : Collections.emptyList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toHash(HashAlgorithm hashAlgorithm, byte[] data) {
        try {
            return MessageDigest.getInstance(hashAlgorithm.value()).digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toHash(HashAlgorithm hashAlgorithm, String text, String charset) {
        return Converter.toHash(hashAlgorithm, text.getBytes(Charset.forName(charset)));
    }

    public static byte[] toHash(HashAlgorithm hashAlgorithm, String text) {
        return Converter.toHash(hashAlgorithm, text.getBytes(Charset.forName("UTF-8")));
    }

    public static String toHashHex(HashAlgorithm hashAlgorithm, String text, String charset) {
        return Bytes.toHex(Converter.toHash(hashAlgorithm, text.getBytes(Charset.forName("UTF-8"))));
    }

    public static String toHashHex(HashAlgorithm hashAlgorithm, String text) {
        return Bytes.toHex(Converter.toHash(hashAlgorithm, text.getBytes(Charset.forName("UTF-8"))));
    }

    public static String toJson(Object clazz) {
        try {
            return JSON_MAPPER.writeValueAsString(clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Map<String, T> toMapByClass(Object clazz) {
        return (Map)JSON_MAPPER.convertValue(clazz, new TypeReference<Map<String, T>>(){});
    }

    public static <T> List<Map<String, T>> toMapListByClassList(Object clazz) {
        return (List)JSON_MAPPER.convertValue(clazz, new TypeReference<List<Map<String, T>>>(){});
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable, boolean parallel) {
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return Converter.toStream(iterable, false);
    }

    public static <T> Stream<T> toStream(final Enumeration<T> enumeration, boolean parallel) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }
        }, 16), parallel);
    }

    public static <T> Stream<T> toStream(Enumeration<T> enumeration) {
        return Converter.toStream(enumeration, false);
    }

    public static Stream<String> toStreamLineNotCloseByTextInputStream(InputStream inputStream, String charset) throws IOException {
        return new BufferedReader(new InputStreamReader(inputStream, Charset.forName(charset))).lines();
    }

    public static <T> List<T> toList(Enumeration<T> enumeration) {
        return Collections.list(enumeration);
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return Converter.toStream(iterable, false).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> toMap(Object ... entries) {
        return Maps.toMap(entries);
    }

    public static <R> Stream<R> toStreamByResultSet(final ResultSet resultSet, final ThrowableFunction<ResultSet, R> map) throws SQLException {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                try {
                    if (!resultSet.next()) {
                        return false;
                    }
                    action.accept(map.apply(resultSet));
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, false);
    }

    public static <R> Stream<R> toStreamByResultSet(ResultSet resultSet, ThrowableBiFunction<String[], Object[], R> map) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] columnNames = new String[columnCount];
        int i = 0;
        while (i <= columnCount) {
            columnNames[i++] = rsmd.getColumnName(i);
        }
        return Converter.toStreamByResultSet(resultSet, (ResultSet rs) -> {
            Object[] vals = new Object[columnCount];
            int i = 0;
            while (i <= columnCount) {
                vals[i++] = rs.getObject(i);
            }
            return map.apply(columnNames, vals);
        });
    }

    public static String toString(Exception e) {
        if (e == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(512);
        sb.append(e.getMessage());
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            sb.append("\r\n").append(stackTraceElement.toString());
        }
        return sb.toString();
    }

    public static String toStringNotClose(InputStream is, String charset) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder(4096);
        char[] buf = new char[4096];
        InputStreamReader isr = new InputStreamReader(is, charset);
        while ((len = isr.read(buf, 0, 4096)) > -1) {
            sb.append(buf, 0, len);
        }
        return sb.toString();
    }

    public static String toString(URL url, String charset) throws IOException {
        return Converter.toString(url.openStream(), charset);
    }

    public static String toString(File file, String charset) throws IOException {
        String string;
        try (FileInputStream fis = new FileInputStream(file);){
            string = Converter.toStringNotClose(fis, charset);
        }
        return string;
    }

    public static String toString(InputStream inputStream, String charset) throws IOException {
        String string;
        block8: {
            InputStream is = inputStream;
            try {
                string = Converter.toStringNotClose(is, charset);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return string;
    }
}

