/*
 * Decompiled with CFR 0.152.
 */
package me.saro.commons.excel;

import java.util.Date;
import me.saro.commons.Utils;
import me.saro.commons.excel.ExcelRow;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public class ExcelCell {
    final ExcelRow row;
    final int cellIndex;
    private Cell pCell;

    ExcelCell(ExcelRow row, int cellIndex) {
        this.row = row;
        this.cellIndex = cellIndex;
    }

    public Cell getPoiCell(boolean force) {
        Row pRow = this.row.getPoiRow(force);
        if (pRow != null) {
            this.pCell = pRow.getCell(this.cellIndex);
            if (this.pCell == null && force) {
                this.pCell = pRow.createCell(this.cellIndex);
            }
        }
        return this.pCell;
    }

    public boolean isEmpty() {
        return this.getPoiCell(false) == null;
    }

    public ExcelCell getNextCell() {
        return new ExcelCell(this.row, this.cellIndex + 1);
    }

    public ExcelCell getNextRowCell() {
        return new ExcelCell(this.row.getNextRow(), this.cellIndex);
    }

    public ExcelCell set(Object val) {
        ExcelCell.setCellValueAuto(this.getPoiCell(true), val);
        return this;
    }

    public int getIntValue(int defaultValue) {
        return (int)ExcelCell.toDouble(this.getPoiCell(false), defaultValue);
    }

    public long getLongValue(long defaultValue) {
        return (long)ExcelCell.toDouble(this.getPoiCell(false), defaultValue);
    }

    public float getFloatValue(float defaultValue) {
        return (float)ExcelCell.toDouble(this.getPoiCell(false), defaultValue);
    }

    public double getDoubleValue(double defaultValue) {
        return ExcelCell.toDouble(this.getPoiCell(false), defaultValue);
    }

    public int getIntValue() {
        return (int)ExcelCell.toDouble(this.getPoiCell(false));
    }

    public long getLongValue() {
        return (long)ExcelCell.toDouble(this.getPoiCell(false));
    }

    public float getFloatValue() {
        return (float)ExcelCell.toDouble(this.getPoiCell(false));
    }

    public double getDoubleValue() {
        return ExcelCell.toDouble(this.getPoiCell(false));
    }

    public Date getDateValue(Date defaultValue) {
        return ExcelCell.toDate(this.getPoiCell(false), defaultValue);
    }

    public String getIntegerStringValue(long defaultValue) {
        return Long.toString(this.getLongValue(defaultValue));
    }

    public String getStringValue(String defaultValue) {
        return ExcelCell.toString(this.getPoiCell(false), defaultValue);
    }

    public String getStringValue() {
        return ExcelCell.toString(this.getPoiCell(false), null);
    }

    public static double toDouble(Cell cell, double defaultValue) {
        try {
            return ExcelCell.toDouble(cell);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double toDouble(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue() ? 1.0 : 0.0;
                }
                case NUMERIC: {
                    return cell.getNumericCellValue();
                }
                case FORMULA: {
                    String tmp = cell.getCellFormula();
                    if (tmp != null && !tmp.isEmpty()) {
                        return Utils.parseDouble((String)tmp);
                    }
                }
                case STRING: {
                    String tmp = cell.getStringCellValue();
                    if (tmp == null || tmp.isEmpty()) break;
                    return Utils.parseDouble((String)tmp);
                }
            }
        }
        throw new IllegalArgumentException(cell + " is not number");
    }

    public static Date toDate(Cell cell, Date defaultValue) {
        if (cell.getCellType() == CellType.STRING) {
            try {
                return cell.getDateCellValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String toString(Cell cell, String defaultValue) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case BOOLEAN: {
                    return cell.getBooleanCellValue() ? "1" : "0";
                }
                case FORMULA: {
                    return cell.getCellFormula();
                }
                case NUMERIC: {
                    return Double.toString(cell.getNumericCellValue());
                }
                case STRING: {
                    return cell.getStringCellValue();
                }
            }
        }
        return defaultValue;
    }

    static Cell setCellValueAuto(Cell cell, Object obj) {
        if (obj == null) {
            cell.setCellValue((String)null);
            return cell;
        }
        switch (obj.getClass().getName()) {
            case "int": 
            case "java.lang.Integer": {
                cell.setCellValue((double)((Integer)obj).intValue());
                break;
            }
            case "long": 
            case "java.lang.Long": {
                cell.setCellValue((double)((Long)obj).longValue());
                break;
            }
            case "float": 
            case "java.lang.Float": {
                cell.setCellValue((double)((Float)obj).floatValue());
                break;
            }
            case "double": 
            case "java.lang.Double": {
                cell.setCellValue(((Double)obj).doubleValue());
                break;
            }
            case "Date": {
                cell.setCellValue((Date)obj);
                break;
            }
            default: {
                cell.setCellValue(obj.toString());
            }
        }
        return cell;
    }

    public static String toColumnNameByCellIndex(int cellIndex) {
        int offset = 4;
        int max = 4;
        int idx = cellIndex;
        char[] rv = new char[max];
        do {
            rv[--offset] = (char)(65 + idx % 26);
        } while ((idx = idx / 26 - 1) >= 0);
        return new String(rv, offset, max - offset);
    }

    public static String toColumnName(int rowIndex, int cellIndex) {
        return ExcelCell.toColumnNameByCellIndex(cellIndex) + ExcelRow.toColumnNameByRowIndex(rowIndex);
    }

    public static int toCellIndex(String cellColumnName) {
        if (!cellColumnName.matches("[A-Z]{1,3}")) {
            throw new IllegalArgumentException(cellColumnName + " is not cellColumnName : ex) AF");
        }
        char[] ca = cellColumnName.toCharArray();
        int rv = 0;
        int pos = 0;
        switch (ca.length) {
            case 3: {
                rv += (ca[pos++] - 65 + 1) * 26 * 26;
            }
            case 2: {
                rv += (ca[pos++] - 65 + 1) * 26;
            }
            case 1: {
                rv += ca[pos++] - 65;
            }
        }
        return rv;
    }

    public static int[] toRowCellIndex(String columnName) {
        if (!columnName.matches("[A-Z]+[\\d]+")) {
            throw new IllegalArgumentException(columnName + " is not columnName : ex) E3");
        }
        return new int[]{ExcelRow.toRowIndex(columnName.replaceFirst("[A-Z]+", "")), ExcelCell.toCellIndex(columnName.replaceFirst("[\\d]+", ""))};
    }
}

