/*
 * Decompiled with CFR 0.152.
 */
package me.rahimklaber.stellar.base.xdr;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.rahimklaber.stellar.base.xdr.AccountID;
import me.rahimklaber.stellar.base.xdr.ClaimableBalanceID;
import me.rahimklaber.stellar.base.xdr.Hash;
import me.rahimklaber.stellar.base.xdr.LedgerEntryType;
import me.rahimklaber.stellar.base.xdr.LedgerKeyAccount;
import me.rahimklaber.stellar.base.xdr.LedgerKeyClaimableBalance;
import me.rahimklaber.stellar.base.xdr.LedgerKeyData;
import me.rahimklaber.stellar.base.xdr.LedgerKeyLiquidityPool;
import me.rahimklaber.stellar.base.xdr.LedgerKeyOffer;
import me.rahimklaber.stellar.base.xdr.LedgerKeyTrustline;
import me.rahimklaber.stellar.base.xdr.String64;
import me.rahimklaber.stellar.base.xdr.TrustLineAsset;
import me.rahimklaber.stellar.base.xdr.XdrElement;
import me.rahimklaber.stellar.base.xdr.XdrElementDecoder;
import me.rahimklaber.stellar.base.xdr.XdrStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0006\f\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lme/rahimklaber/stellar/base/xdr/LedgerKey;", "Lme/rahimklaber/stellar/base/xdr/XdrElement;", "type", "Lme/rahimklaber/stellar/base/xdr/LedgerEntryType;", "(Lme/rahimklaber/stellar/base/xdr/LedgerEntryType;)V", "getType", "()Lme/rahimklaber/stellar/base/xdr/LedgerEntryType;", "encode", "", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "Companion", "Lme/rahimklaber/stellar/base/xdr/LedgerKeyAccount;", "Lme/rahimklaber/stellar/base/xdr/LedgerKeyClaimableBalance;", "Lme/rahimklaber/stellar/base/xdr/LedgerKeyData;", "Lme/rahimklaber/stellar/base/xdr/LedgerKeyLiquidityPool;", "Lme/rahimklaber/stellar/base/xdr/LedgerKeyOffer;", "Lme/rahimklaber/stellar/base/xdr/LedgerKeyTrustline;", "stellar_kt"})
public abstract class LedgerKey
implements XdrElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LedgerEntryType type;

    private LedgerKey(LedgerEntryType type) {
        this.type = type;
    }

    @NotNull
    public final LedgerEntryType getType() {
        return this.type;
    }

    @Override
    public void encode(@NotNull XdrStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.type.encode(stream);
    }

    public /* synthetic */ LedgerKey(LedgerEntryType type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lme/rahimklaber/stellar/base/xdr/LedgerKey$Companion;", "Lme/rahimklaber/stellar/base/xdr/XdrElementDecoder;", "Lme/rahimklaber/stellar/base/xdr/LedgerKey;", "()V", "decode", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "stellar_kt"})
    public static final class Companion
    implements XdrElementDecoder<LedgerKey> {
        private Companion() {
        }

        @Override
        @NotNull
        public LedgerKey decode(@NotNull XdrStream stream) {
            LedgerKey ledgerKey;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            LedgerEntryType type = LedgerEntryType.Companion.decode(stream);
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    AccountID accountID = AccountID.Companion.decode(stream);
                    ledgerKey = new LedgerKeyAccount(accountID);
                    break;
                }
                case 2: {
                    AccountID accountID = AccountID.Companion.decode(stream);
                    TrustLineAsset asset = TrustLineAsset.Companion.decode(stream);
                    ledgerKey = new LedgerKeyTrustline(accountID, asset);
                    break;
                }
                case 3: {
                    AccountID sellerID = AccountID.Companion.decode(stream);
                    long offerID = stream.readLong();
                    ledgerKey = new LedgerKeyOffer(sellerID, offerID);
                    break;
                }
                case 4: {
                    AccountID accountID = AccountID.Companion.decode(stream);
                    String64 dataName = String64.Companion.decode(stream);
                    ledgerKey = new LedgerKeyData(accountID, dataName);
                    break;
                }
                case 5: {
                    ClaimableBalanceID balanceID = ClaimableBalanceID.Companion.decode(stream);
                    ledgerKey = new LedgerKeyClaimableBalance(balanceID);
                    break;
                }
                case 6: {
                    Hash liquidityPoolID = Hash.Companion.decode(stream);
                    ledgerKey = new LedgerKeyLiquidityPool(liquidityPoolID);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Could not decode LedgerKey for type: " + type);
                }
            }
            return ledgerKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LedgerEntryType.values().length];
                try {
                    nArray[LedgerEntryType.ACCOUNT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LedgerEntryType.TRUSTLINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LedgerEntryType.OFFER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LedgerEntryType.DATA.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LedgerEntryType.CLAIMABLE_BALANCE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LedgerEntryType.LIQUIDITY_POOL.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

