/*
 * Decompiled with CFR 0.152.
 */
package me.rahimklaber.stellar.base.operations;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.rahimklaber.stellar.base.Asset;
import me.rahimklaber.stellar.base.StrKey;
import me.rahimklaber.stellar.base.StrKeyKt;
import me.rahimklaber.stellar.base.TokenAmount;
import me.rahimklaber.stellar.base.operations.Operation;
import me.rahimklaber.stellar.base.xdr.MuxedAccount;
import me.rahimklaber.stellar.base.xdr.Operation;
import me.rahimklaber.stellar.base.xdr.PaymentOp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lme/rahimklaber/stellar/base/operations/Payment;", "Lme/rahimklaber/stellar/base/operations/Operation;", "destination", "", "asset", "Lme/rahimklaber/stellar/base/Asset;", "amount", "Lme/rahimklaber/stellar/base/TokenAmount;", "sourceAccount", "(Ljava/lang/String;Lme/rahimklaber/stellar/base/Asset;Lme/rahimklaber/stellar/base/TokenAmount;Ljava/lang/String;)V", "getAmount", "()Lme/rahimklaber/stellar/base/TokenAmount;", "getAsset", "()Lme/rahimklaber/stellar/base/Asset;", "getDestination", "()Ljava/lang/String;", "getSourceAccount", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXdr", "Lme/rahimklaber/stellar/base/xdr/Operation;", "stellar_kt"})
public final class Payment
implements Operation {
    @NotNull
    private final String destination;
    @NotNull
    private final Asset asset;
    @NotNull
    private final TokenAmount amount;
    @Nullable
    private final String sourceAccount;

    public Payment(@NotNull String destination, @NotNull Asset asset, @NotNull TokenAmount amount, @Nullable String sourceAccount) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        this.destination = destination;
        this.asset = asset;
        this.amount = amount;
        this.sourceAccount = sourceAccount;
    }

    public /* synthetic */ Payment(String string, Asset asset, TokenAmount tokenAmount, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(string, asset, tokenAmount, string2);
    }

    @NotNull
    public final String getDestination() {
        return this.destination;
    }

    @NotNull
    public final Asset getAsset() {
        return this.asset;
    }

    @NotNull
    public final TokenAmount getAmount() {
        return this.amount;
    }

    @Override
    @Nullable
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Override
    @NotNull
    public me.rahimklaber.stellar.base.xdr.Operation toXdr() {
        MuxedAccount muxedAccount;
        String string = this.getSourceAccount();
        if (string != null) {
            String it = string;
            boolean bl = false;
            muxedAccount = StrKeyKt.encodeToMuxedAccountXDR(StrKey.INSTANCE, it);
        } else {
            muxedAccount = null;
        }
        MuxedAccount source = muxedAccount;
        return new Operation.Payment(source, new PaymentOp(StrKeyKt.encodeToMuxedAccountXDR(StrKey.INSTANCE, this.destination), this.asset.toXdr(), this.amount.getValue()));
    }

    @NotNull
    public final String component1() {
        return this.destination;
    }

    @NotNull
    public final Asset component2() {
        return this.asset;
    }

    @NotNull
    public final TokenAmount component3() {
        return this.amount;
    }

    @Nullable
    public final String component4() {
        return this.sourceAccount;
    }

    @NotNull
    public final Payment copy(@NotNull String destination, @NotNull Asset asset, @NotNull TokenAmount amount, @Nullable String sourceAccount) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return new Payment(destination, asset, amount, sourceAccount);
    }

    public static /* synthetic */ Payment copy$default(Payment payment, String string, Asset asset, TokenAmount tokenAmount, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = payment.destination;
        }
        if ((n & 2) != 0) {
            asset = payment.asset;
        }
        if ((n & 4) != 0) {
            tokenAmount = payment.amount;
        }
        if ((n & 8) != 0) {
            string2 = payment.sourceAccount;
        }
        return payment.copy(string, asset, tokenAmount, string2);
    }

    @NotNull
    public String toString() {
        return "Payment(destination=" + this.destination + ", asset=" + this.asset + ", amount=" + this.amount + ", sourceAccount=" + this.sourceAccount + ')';
    }

    public int hashCode() {
        int result = this.destination.hashCode();
        result = result * 31 + this.asset.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + (this.sourceAccount == null ? 0 : this.sourceAccount.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Payment)) {
            return false;
        }
        Payment payment = (Payment)other;
        if (!Intrinsics.areEqual((Object)this.destination, (Object)payment.destination)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.asset, (Object)payment.asset)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.amount, (Object)payment.amount)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sourceAccount, (Object)payment.sourceAccount);
    }
}

