/*
 * Decompiled with CFR 0.152.
 */
package me.rahimklaber.stellar.base;

import io.matthewnelson.encoding.base32.Base32;
import io.matthewnelson.encoding.builders.Base32Kt;
import io.matthewnelson.encoding.core.Decoder;
import io.matthewnelson.encoding.core.Encoder;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.rahimklaber.stellar.base.StrKey;
import me.rahimklaber.stellar.base.StrKeyKt;
import me.rahimklaber.stellar.base.VersionByte;
import me.rahimklaber.stellar.base.xdr.AccountID;
import me.rahimklaber.stellar.base.xdr.ExtensionsKt;
import me.rahimklaber.stellar.base.xdr.MuxedAccount;
import me.rahimklaber.stellar.base.xdr.PublicKey;
import me.rahimklaber.stellar.base.xdr.XdrStream;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u0010\u000e\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0010*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\r\u001a\u0012\u0010\u0018\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u001a\u0010\u001a\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001d\u001a\u00020\u001e*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"b32Table", "", "getB32Table", "()[B", "b32Table$delegate", "Lkotlin/Lazy;", "base32Encoding", "Lio/matthewnelson/encoding/base32/Base32$Default;", "calculateChecksum", "bytes", "decodeAccountId", "Lme/rahimklaber/stellar/base/StrKey;", "account", "", "decodeCheck", "versionByte", "Lme/rahimklaber/stellar/base/VersionByte;", "encoded", "", "decodeMuxedAccountId", "decodeSecretSeed", "secretSeed", "decodeVersionByte", "data", "encodeAccountId", "pubkey", "encodeCheck", "encodeToAccountIDXDR", "Lme/rahimklaber/stellar/base/xdr/AccountID;", "encodeToMuxedAccountXDR", "Lme/rahimklaber/stellar/base/xdr/MuxedAccount;", "stellar_kt"})
@SourceDebugExtension(value={"SMAP\nStrKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrKey.kt\nme/rahimklaber/stellar/base/StrKeyKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class StrKeyKt {
    @NotNull
    private static final Lazy b32Table$delegate = LazyKt.lazy((Function0)b32Table.2.INSTANCE);
    @NotNull
    private static final Base32.Default base32Encoding = Base32Kt.Base32Default((Function1)base32Encoding.1.INSTANCE);

    private static final byte[] getB32Table() {
        Lazy lazy = b32Table$delegate;
        return (byte[])lazy.getValue();
    }

    @NotNull
    public static final AccountID encodeToAccountIDXDR(@NotNull StrKey $this$encodeToAccountIDXDR, @NotNull String account2) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToAccountIDXDR, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        return new AccountID(new PublicKey.PublicKeyEd25519(ExtensionsKt.toUint256(StrKeyKt.decodeAccountId($this$encodeToAccountIDXDR, account2))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MuxedAccount encodeToMuxedAccountXDR(@NotNull StrKey $this$encodeToMuxedAccountXDR, @NotNull String account2) {
        MuxedAccount muxedAccount;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToMuxedAccountXDR, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        VersionByte versionByte = StrKeyKt.decodeVersionByte($this$encodeToMuxedAccountXDR, account2);
        switch (versionByte == null ? -1 : WhenMappings.$EnumSwitchMapping$0[versionByte.ordinal()]) {
            case 1: {
                muxedAccount = new MuxedAccount.Ed25519(ExtensionsKt.toUint256(StrKeyKt.decodeAccountId($this$encodeToMuxedAccountXDR, account2)));
                break;
            }
            case 2: {
                void var3_3;
                XdrStream stream = new XdrStream();
                stream.writeBytes(StrKeyKt.decodeMuxedAccountId($this$encodeToMuxedAccountXDR, account2));
                MuxedAccount muxedAccount2 = MuxedAccount.Companion.decode(stream);
                if (!(muxedAccount2 instanceof MuxedAccount.MuxedEd25519)) {
                    boolean bl = false;
                    String string = "should be muxed";
                    throw new IllegalArgumentException(string.toString());
                }
                muxedAccount = var3_3;
                break;
            }
            default: {
                throw new IllegalArgumentException("could not decode " + account2 + " as MuxedAccountXDR");
            }
        }
        return muxedAccount;
    }

    @NotNull
    public static final byte[] decodeAccountId(@NotNull StrKey $this$decodeAccountId, @NotNull String account2) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeAccountId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        char[] cArray = account2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        return StrKeyKt.decodeCheck($this$decodeAccountId, VersionByte.ACCOUNT_ID, cArray);
    }

    @NotNull
    public static final byte[] decodeMuxedAccountId(@NotNull StrKey $this$decodeMuxedAccountId, @NotNull String account2) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeMuxedAccountId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)account2, (String)"account");
        char[] cArray = account2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        return StrKeyKt.decodeCheck($this$decodeMuxedAccountId, VersionByte.MUXED, cArray);
    }

    @NotNull
    public static final byte[] decodeSecretSeed(@NotNull StrKey $this$decodeSecretSeed, @NotNull String secretSeed) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeSecretSeed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)secretSeed, (String)"secretSeed");
        char[] cArray = secretSeed.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        return StrKeyKt.decodeCheck($this$decodeSecretSeed, VersionByte.SEED, cArray);
    }

    @NotNull
    public static final String encodeAccountId(@NotNull StrKey $this$encodeAccountId, @NotNull byte[] pubkey) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeAccountId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pubkey, (String)"pubkey");
        return StrKeyKt.encodeCheck($this$encodeAccountId, VersionByte.ACCOUNT_ID, pubkey);
    }

    @Nullable
    public static final VersionByte decodeVersionByte(@NotNull StrKey $this$decodeVersionByte, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeVersionByte, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte by = Decoder.Companion.decodeToByteArray((CharSequence)data, (Decoder)base32Encoding)[0];
        return VersionByte.Companion.findByValue(by);
    }

    @NotNull
    public static final byte[] decodeCheck(@NotNull StrKey $this$decodeCheck, @NotNull VersionByte versionByte, @NotNull char[] encoded) {
        byte[] payload;
        Intrinsics.checkNotNullParameter((Object)$this$decodeCheck, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)versionByte), (String)"versionByte");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        byte[] bytes = new byte[encoded.length];
        int n = encoded.length;
        for (int i = 0; i < n; ++i) {
            bytes[i] = (byte)encoded[i];
        }
        if (bytes.length < 5) {
            throw new IllegalArgumentException("Encoded char array must have a length of at least 5.");
        }
        int leftoverBits = bytes.length * 5 % 8;
        if (leftoverBits >= 5) {
            throw new IllegalArgumentException("Encoded char array has leftover character.");
        }
        if (leftoverBits > 0) {
            byte leftoverBitsMask;
            byte lastChar = bytes[bytes.length - 1];
            byte decodedLastChar = StrKeyKt.getB32Table()[lastChar];
            if ((decodedLastChar & (leftoverBitsMask = (byte)(15 >> 4 - leftoverBits))) != 0) {
                throw new IllegalArgumentException("Unused bits should be set to 0.");
            }
        }
        byte[] decoded = Decoder.Companion.decodeToByteArray(encoded, (Decoder)base32Encoding);
        byte decodedVersionByte = decoded[0];
        byte[] byArray = decoded;
        int n2 = 0;
        int n3 = decoded.length - 2;
        byte[] byArray2 = payload = ArraysKt.copyOfRange((byte[])byArray, (int)n2, (int)n3);
        n3 = 1;
        int n4 = payload.length;
        byte[] data = ArraysKt.copyOfRange((byte[])byArray2, (int)n3, (int)n4);
        byte[] byArray3 = decoded;
        n4 = decoded.length - 2;
        int n5 = decoded.length;
        byte[] checksum = ArraysKt.copyOfRange((byte[])byArray3, (int)n4, (int)n5);
        if (decodedVersionByte != versionByte.getValue()) {
            throw new Exception("Version byte is invalid");
        }
        byte[] expectedChecksum = StrKeyKt.calculateChecksum(payload);
        if (!Arrays.equals(expectedChecksum, checksum)) {
            throw new Exception("Checksum invalid");
        }
        if (VersionByte.SEED.getValue() == decodedVersionByte) {
            // empty if block
        }
        return data;
    }

    @NotNull
    public static final String encodeCheck(@NotNull StrKey $this$encodeCheck, @NotNull VersionByte versionByte, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeCheck, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)versionByte), (String)"versionByte");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Buffer outputStream = new Buffer();
        outputStream.writeByte(versionByte.getValue());
        outputStream.write(data);
        byte[] payload = outputStream.readByteArray();
        byte[] checksum = StrKeyKt.calculateChecksum(payload);
        outputStream.write(payload);
        outputStream.write(checksum);
        byte[] unencoded = outputStream.readByteArray();
        return StringsKt.concatToString((char[])Encoder.Companion.encodeToCharArray(unencoded, (Encoder)base32Encoding));
    }

    private static final byte[] calculateChecksum(byte[] bytes) {
        int crc = 0;
        int i = 0;
        int code = 0;
        for (int count = bytes.length; count > 0; --count) {
            code = crc >>> 8 & 0xFF;
            code ^= bytes[i++] & 0xFF;
            code ^= code >>> 4;
            crc = crc << 8 & 0xFFFF;
            crc ^= code;
            code = code << 5 & 0xFFFF;
            crc ^= code;
            code = code << 7 & 0xFFFF;
            crc ^= code;
        }
        byte[] byArray = new byte[]{(byte)crc, (byte)(crc >>> 8)};
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VersionByte.values().length];
            try {
                nArray[VersionByte.ACCOUNT_ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VersionByte.MUXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

