/*
 * Decompiled with CFR 0.152.
 */
package me.rahimklaber.stellar.base.xdr;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.rahimklaber.stellar.base.xdr.SignerKeyEd25519SignedPayload;
import me.rahimklaber.stellar.base.xdr.SignerKeyType;
import me.rahimklaber.stellar.base.xdr.Uint256;
import me.rahimklaber.stellar.base.xdr.XdrElement;
import me.rahimklaber.stellar.base.xdr.XdrElementDecoder;
import me.rahimklaber.stellar.base.xdr.XdrStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b2\u00020\u0001:\u0005\u000b\f\r\u000e\u000fB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lme/rahimklaber/stellar/base/xdr/SignerKey;", "Lme/rahimklaber/stellar/base/xdr/XdrElement;", "type", "Lme/rahimklaber/stellar/base/xdr/SignerKeyType;", "(Lme/rahimklaber/stellar/base/xdr/SignerKeyType;)V", "getType", "()Lme/rahimklaber/stellar/base/xdr/SignerKeyType;", "encode", "", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "Companion", "Ed25519SignedPayloadSignerKey", "Ed25519SignerKey", "HashXSignerKey", "PreAuthSignerKey", "Lme/rahimklaber/stellar/base/xdr/SignerKey$Ed25519SignedPayloadSignerKey;", "Lme/rahimklaber/stellar/base/xdr/SignerKey$Ed25519SignerKey;", "Lme/rahimklaber/stellar/base/xdr/SignerKey$HashXSignerKey;", "Lme/rahimklaber/stellar/base/xdr/SignerKey$PreAuthSignerKey;", "stellar_kt"})
public abstract class SignerKey
implements XdrElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignerKeyType type;

    private SignerKey(SignerKeyType type) {
        this.type = type;
    }

    @NotNull
    public final SignerKeyType getType() {
        return this.type;
    }

    @Override
    public void encode(@NotNull XdrStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.type.encode(stream);
    }

    public /* synthetic */ SignerKey(SignerKeyType type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lme/rahimklaber/stellar/base/xdr/SignerKey$Companion;", "Lme/rahimklaber/stellar/base/xdr/XdrElementDecoder;", "Lme/rahimklaber/stellar/base/xdr/SignerKey;", "()V", "decode", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "stellar_kt"})
    public static final class Companion
    implements XdrElementDecoder<SignerKey> {
        private Companion() {
        }

        @Override
        @NotNull
        public SignerKey decode(@NotNull XdrStream stream) {
            SignerKey signerKey;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            switch (WhenMappings.$EnumSwitchMapping$0[SignerKeyType.Companion.decode(stream).ordinal()]) {
                case 1: {
                    Uint256 ed25519 = Uint256.Companion.decode(stream);
                    signerKey = new Ed25519SignerKey(ed25519);
                    break;
                }
                case 2: {
                    Uint256 preAuthTx = Uint256.Companion.decode(stream);
                    signerKey = new PreAuthSignerKey(preAuthTx);
                    break;
                }
                case 3: {
                    Uint256 hashX = Uint256.Companion.decode(stream);
                    signerKey = new HashXSignerKey(hashX);
                    break;
                }
                case 4: {
                    SignerKeyEd25519SignedPayload payload = SignerKeyEd25519SignedPayload.Companion.decode(stream);
                    signerKey = new Ed25519SignedPayloadSignerKey(payload);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return signerKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SignerKeyType.values().length];
                try {
                    nArray[SignerKeyType.SIGNER_KEY_TYPE_ED25519.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignerKeyType.SIGNER_KEY_TYPE_PRE_AUTH_TX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignerKeyType.SIGNER_KEY_TYPE_HASH_X.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SignerKeyType.SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lme/rahimklaber/stellar/base/xdr/SignerKey$Ed25519SignedPayloadSignerKey;", "Lme/rahimklaber/stellar/base/xdr/SignerKey;", "ed25519SignedPayload", "Lme/rahimklaber/stellar/base/xdr/SignerKeyEd25519SignedPayload;", "(Lme/rahimklaber/stellar/base/xdr/SignerKeyEd25519SignedPayload;)V", "getEd25519SignedPayload", "()Lme/rahimklaber/stellar/base/xdr/SignerKeyEd25519SignedPayload;", "component1", "copy", "encode", "", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "equals", "", "other", "", "hashCode", "", "toString", "", "stellar_kt"})
    public static final class Ed25519SignedPayloadSignerKey
    extends SignerKey {
        @NotNull
        private final SignerKeyEd25519SignedPayload ed25519SignedPayload;

        public Ed25519SignedPayloadSignerKey(@NotNull SignerKeyEd25519SignedPayload ed25519SignedPayload) {
            Intrinsics.checkNotNullParameter((Object)ed25519SignedPayload, (String)"ed25519SignedPayload");
            super(SignerKeyType.SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD, null);
            this.ed25519SignedPayload = ed25519SignedPayload;
        }

        @NotNull
        public final SignerKeyEd25519SignedPayload getEd25519SignedPayload() {
            return this.ed25519SignedPayload;
        }

        @Override
        public void encode(@NotNull XdrStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            super.encode(stream);
            this.ed25519SignedPayload.encode(stream);
        }

        @NotNull
        public final SignerKeyEd25519SignedPayload component1() {
            return this.ed25519SignedPayload;
        }

        @NotNull
        public final Ed25519SignedPayloadSignerKey copy(@NotNull SignerKeyEd25519SignedPayload ed25519SignedPayload) {
            Intrinsics.checkNotNullParameter((Object)ed25519SignedPayload, (String)"ed25519SignedPayload");
            return new Ed25519SignedPayloadSignerKey(ed25519SignedPayload);
        }

        public static /* synthetic */ Ed25519SignedPayloadSignerKey copy$default(Ed25519SignedPayloadSignerKey ed25519SignedPayloadSignerKey, SignerKeyEd25519SignedPayload signerKeyEd25519SignedPayload, int n, Object object) {
            if ((n & 1) != 0) {
                signerKeyEd25519SignedPayload = ed25519SignedPayloadSignerKey.ed25519SignedPayload;
            }
            return ed25519SignedPayloadSignerKey.copy(signerKeyEd25519SignedPayload);
        }

        @NotNull
        public String toString() {
            return "Ed25519SignedPayloadSignerKey(ed25519SignedPayload=" + this.ed25519SignedPayload + ')';
        }

        public int hashCode() {
            return this.ed25519SignedPayload.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Ed25519SignedPayloadSignerKey)) {
                return false;
            }
            Ed25519SignedPayloadSignerKey ed25519SignedPayloadSignerKey = (Ed25519SignedPayloadSignerKey)other;
            return Intrinsics.areEqual((Object)this.ed25519SignedPayload, (Object)ed25519SignedPayloadSignerKey.ed25519SignedPayload);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lme/rahimklaber/stellar/base/xdr/SignerKey$Ed25519SignerKey;", "Lme/rahimklaber/stellar/base/xdr/SignerKey;", "ed25519", "Lme/rahimklaber/stellar/base/xdr/Uint256;", "(Lme/rahimklaber/stellar/base/xdr/Uint256;)V", "getEd25519", "()Lme/rahimklaber/stellar/base/xdr/Uint256;", "component1", "copy", "encode", "", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "equals", "", "other", "", "hashCode", "", "toString", "", "stellar_kt"})
    public static final class Ed25519SignerKey
    extends SignerKey {
        @NotNull
        private final Uint256 ed25519;

        public Ed25519SignerKey(@NotNull Uint256 ed25519) {
            Intrinsics.checkNotNullParameter((Object)ed25519, (String)"ed25519");
            super(SignerKeyType.SIGNER_KEY_TYPE_ED25519, null);
            this.ed25519 = ed25519;
        }

        @NotNull
        public final Uint256 getEd25519() {
            return this.ed25519;
        }

        @Override
        public void encode(@NotNull XdrStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            super.encode(stream);
            this.ed25519.encode(stream);
        }

        @NotNull
        public final Uint256 component1() {
            return this.ed25519;
        }

        @NotNull
        public final Ed25519SignerKey copy(@NotNull Uint256 ed25519) {
            Intrinsics.checkNotNullParameter((Object)ed25519, (String)"ed25519");
            return new Ed25519SignerKey(ed25519);
        }

        public static /* synthetic */ Ed25519SignerKey copy$default(Ed25519SignerKey ed25519SignerKey, Uint256 uint256, int n, Object object) {
            if ((n & 1) != 0) {
                uint256 = ed25519SignerKey.ed25519;
            }
            return ed25519SignerKey.copy(uint256);
        }

        @NotNull
        public String toString() {
            return "Ed25519SignerKey(ed25519=" + this.ed25519 + ')';
        }

        public int hashCode() {
            return this.ed25519.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Ed25519SignerKey)) {
                return false;
            }
            Ed25519SignerKey ed25519SignerKey = (Ed25519SignerKey)other;
            return Intrinsics.areEqual((Object)this.ed25519, (Object)ed25519SignerKey.ed25519);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lme/rahimklaber/stellar/base/xdr/SignerKey$HashXSignerKey;", "Lme/rahimklaber/stellar/base/xdr/SignerKey;", "hashX", "Lme/rahimklaber/stellar/base/xdr/Uint256;", "(Lme/rahimklaber/stellar/base/xdr/Uint256;)V", "getHashX", "()Lme/rahimklaber/stellar/base/xdr/Uint256;", "component1", "copy", "encode", "", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "equals", "", "other", "", "hashCode", "", "toString", "", "stellar_kt"})
    public static final class HashXSignerKey
    extends SignerKey {
        @NotNull
        private final Uint256 hashX;

        public HashXSignerKey(@NotNull Uint256 hashX) {
            Intrinsics.checkNotNullParameter((Object)hashX, (String)"hashX");
            super(SignerKeyType.SIGNER_KEY_TYPE_HASH_X, null);
            this.hashX = hashX;
        }

        @NotNull
        public final Uint256 getHashX() {
            return this.hashX;
        }

        @Override
        public void encode(@NotNull XdrStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            super.encode(stream);
            this.hashX.encode(stream);
        }

        @NotNull
        public final Uint256 component1() {
            return this.hashX;
        }

        @NotNull
        public final HashXSignerKey copy(@NotNull Uint256 hashX) {
            Intrinsics.checkNotNullParameter((Object)hashX, (String)"hashX");
            return new HashXSignerKey(hashX);
        }

        public static /* synthetic */ HashXSignerKey copy$default(HashXSignerKey hashXSignerKey, Uint256 uint256, int n, Object object) {
            if ((n & 1) != 0) {
                uint256 = hashXSignerKey.hashX;
            }
            return hashXSignerKey.copy(uint256);
        }

        @NotNull
        public String toString() {
            return "HashXSignerKey(hashX=" + this.hashX + ')';
        }

        public int hashCode() {
            return this.hashX.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HashXSignerKey)) {
                return false;
            }
            HashXSignerKey hashXSignerKey = (HashXSignerKey)other;
            return Intrinsics.areEqual((Object)this.hashX, (Object)hashXSignerKey.hashX);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lme/rahimklaber/stellar/base/xdr/SignerKey$PreAuthSignerKey;", "Lme/rahimklaber/stellar/base/xdr/SignerKey;", "preAuthTx", "Lme/rahimklaber/stellar/base/xdr/Uint256;", "(Lme/rahimklaber/stellar/base/xdr/Uint256;)V", "getPreAuthTx", "()Lme/rahimklaber/stellar/base/xdr/Uint256;", "component1", "copy", "encode", "", "stream", "Lme/rahimklaber/stellar/base/xdr/XdrStream;", "equals", "", "other", "", "hashCode", "", "toString", "", "stellar_kt"})
    public static final class PreAuthSignerKey
    extends SignerKey {
        @NotNull
        private final Uint256 preAuthTx;

        public PreAuthSignerKey(@NotNull Uint256 preAuthTx) {
            Intrinsics.checkNotNullParameter((Object)preAuthTx, (String)"preAuthTx");
            super(SignerKeyType.SIGNER_KEY_TYPE_HASH_X, null);
            this.preAuthTx = preAuthTx;
        }

        @NotNull
        public final Uint256 getPreAuthTx() {
            return this.preAuthTx;
        }

        @Override
        public void encode(@NotNull XdrStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            super.encode(stream);
            this.preAuthTx.encode(stream);
        }

        @NotNull
        public final Uint256 component1() {
            return this.preAuthTx;
        }

        @NotNull
        public final PreAuthSignerKey copy(@NotNull Uint256 preAuthTx) {
            Intrinsics.checkNotNullParameter((Object)preAuthTx, (String)"preAuthTx");
            return new PreAuthSignerKey(preAuthTx);
        }

        public static /* synthetic */ PreAuthSignerKey copy$default(PreAuthSignerKey preAuthSignerKey, Uint256 uint256, int n, Object object) {
            if ((n & 1) != 0) {
                uint256 = preAuthSignerKey.preAuthTx;
            }
            return preAuthSignerKey.copy(uint256);
        }

        @NotNull
        public String toString() {
            return "PreAuthSignerKey(preAuthTx=" + this.preAuthTx + ')';
        }

        public int hashCode() {
            return this.preAuthTx.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreAuthSignerKey)) {
                return false;
            }
            PreAuthSignerKey preAuthSignerKey = (PreAuthSignerKey)other;
            return Intrinsics.areEqual((Object)this.preAuthTx, (Object)preAuthSignerKey.preAuthTx);
        }
    }
}

