/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.react.modules;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.media.RingtoneManager;
import android.os.AsyncTask;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import me.pushy.sdk.Pushy;
import me.pushy.sdk.react.util.PushyPersistence;
import me.pushy.sdk.util.exceptions.PushyException;

public class PushyModule
extends ReactContextBaseJavaModule {
    public PushyModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "PushyModule";
    }

    @ReactMethod
    public void notify(String title, String text) {
        ReactApplicationContext context = this.getReactApplicationContext();
        Notification.Builder builder = new Notification.Builder((Context)context).setSmallIcon(this.getNotificationIcon((Context)context)).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setAutoCancel(true).setVibrate(new long[]{0L, 400L, 250L, 400L}).setContentIntent(this.getMainActivityPendingIntent((Context)context)).setSound(RingtoneManager.getDefaultUri((int)2));
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Pushy.setNotificationChannel((Object)builder, (Context)context);
        notificationManager.notify(text.hashCode(), builder.build());
    }

    @ReactMethod
    public void register(final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String deviceToken = Pushy.register((Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)deviceToken);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void hideNotifications() {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        this.getReactApplicationContext();
        NotificationManager notificationManager = (NotificationManager)reactApplicationContext.getSystemService("notification");
        notificationManager.cancelAll();
    }

    @ReactMethod
    public void listen() {
        Pushy.listen((Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void subscribe(final String topic, final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Pushy.subscribe((String)topic, (Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)true);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void unsubscribe(final String topic, final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Pushy.unsubscribe((String)topic, (Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)true);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void togglePermissionVerification(boolean value) {
        Pushy.togglePermissionVerification((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void toggleDirectConnectivity(boolean value) {
        Pushy.toggleDirectConnectivity((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void toggleNotifications(boolean value) {
        Pushy.toggleNotifications((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setHeartbeatInterval(int seconds) {
        Pushy.setHeartbeatInterval((int)seconds, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setEnterpriseConfig(String apiEndpoint, String mqttEndpoint) {
        Pushy.setEnterpriseConfig((String)apiEndpoint, (String)mqttEndpoint, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void isRegistered(Promise promise) {
        promise.resolve((Object)Pushy.isRegistered((Context)this.getReactApplicationContext()));
    }

    @ReactMethod
    public void getDeviceCredentials(Promise promise) {
        promise.resolve((Object)Pushy.getDeviceCredentials((Context)this.getReactApplicationContext()));
    }

    private PendingIntent getMainActivityPendingIntent(Context context) {
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getApplicationContext().getPackageName());
        launchIntent.addFlags(0x24000000);
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)launchIntent, (int)0x8000000);
    }

    @ReactMethod
    public void setNotificationIcon(String iconResourceName) {
        PushyPersistence.setNotificationIcon(iconResourceName, (Context)this.getReactApplicationContext());
    }

    private int getNotificationIcon(Context context) {
        String icon = PushyPersistence.getNotificationIcon(context);
        if (icon != null) {
            String packageName;
            Resources resources = context.getResources();
            int iconId = resources.getIdentifier(icon, "drawable", packageName = context.getPackageName());
            if (iconId != 0) {
                return iconId;
            }
            iconId = resources.getIdentifier(icon, "mipmap", packageName);
            if (iconId != 0) {
                return iconId;
            }
        }
        return 17301659;
    }
}

