/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.react.modules;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.media.RingtoneManager;
import android.os.AsyncTask;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import me.pushy.sdk.Pushy;
import me.pushy.sdk.react.util.PushyMapUtils;
import me.pushy.sdk.react.util.PushyPersistence;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import org.json.JSONObject;

public class PushyModule
extends ReactContextBaseJavaModule
implements ActivityEventListener {
    public PushyModule(ReactApplicationContext reactContext) {
        super(reactContext);
        reactContext.addActivityEventListener((ActivityEventListener)this);
    }

    public String getName() {
        return "PushyModule";
    }

    @ReactMethod
    public void notify(String title, String text, ReadableMap payload) {
        ReactApplicationContext context = this.getReactApplicationContext();
        Notification.Builder builder = new Notification.Builder((Context)context).setSmallIcon(this.getNotificationIcon((Context)context)).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setAutoCancel(true).setVibrate(new long[]{0L, 400L, 250L, 400L}).setContentIntent(this.getMainActivityPendingIntent((Context)context, payload)).setSound(RingtoneManager.getDefaultUri((int)2));
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Pushy.setNotificationChannel((Object)builder, (Context)context);
        notificationManager.notify(text.hashCode(), builder.build());
    }

    @ReactMethod
    public void register(final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String deviceToken = Pushy.register((Context)(PushyModule.this.getCurrentActivity() != null ? PushyModule.this.getCurrentActivity() : PushyModule.this.getReactApplicationContext()));
                    promise.resolve((Object)deviceToken);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void hideNotifications() {
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        this.getReactApplicationContext();
        NotificationManager notificationManager = (NotificationManager)reactApplicationContext.getSystemService("notification");
        notificationManager.cancelAll();
    }

    @ReactMethod
    public void listen() {
        Pushy.listen((Context)this.getReactApplicationContext());
        if (this.getReactApplicationContext() == null || this.getReactApplicationContext().getCurrentActivity() == null || this.getReactApplicationContext().getCurrentActivity().getIntent() == null) {
            return;
        }
        this.onNotificationClicked(this.getReactApplicationContext().getCurrentActivity().getIntent());
    }

    @ReactMethod
    public void subscribe(final String topic, final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Pushy.subscribe((String)topic, (Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)true);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void unsubscribe(final String topic, final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Pushy.unsubscribe((String)topic, (Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)true);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void setAppId(String appId) {
        Pushy.setAppId((String)appId, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void togglePermissionVerification(boolean value) {
        Pushy.togglePermissionVerification((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void toggleDirectConnectivity(boolean value) {
        Pushy.toggleDirectConnectivity((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void toggleNotifications(boolean value) {
        Pushy.toggleNotifications((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setHeartbeatInterval(int seconds) {
        Pushy.setHeartbeatInterval((int)seconds, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setJobServiceInterval(int seconds) {
        Pushy.setJobServiceInterval((int)seconds, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setEnterpriseConfig(String apiEndpoint, String mqttEndpoint) {
        Pushy.setEnterpriseConfig((String)apiEndpoint, (String)mqttEndpoint, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void toggleFCM(boolean value) {
        Pushy.toggleFCM((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setProxyEndpoint(String proxyEndpoint) {
        Pushy.setProxyEndpoint((String)proxyEndpoint, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setEnterpriseCertificate(String enterpriseCert) {
        Pushy.setEnterpriseCertificate((String)enterpriseCert, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void isRegistered(Promise promise) {
        promise.resolve((Object)Pushy.isRegistered((Context)this.getReactApplicationContext()));
    }

    @ReactMethod
    public void getDeviceCredentials(Promise promise) {
        promise.resolve((Object)Pushy.getDeviceCredentials((Context)this.getReactApplicationContext()));
    }

    private PendingIntent getMainActivityPendingIntent(Context context, ReadableMap payload) {
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getApplicationContext().getPackageName());
        launchIntent.addFlags(0x24000000);
        String json = "{}";
        try {
            json = PushyMapUtils.convertMapToJson(payload).toString();
        }
        catch (Exception e) {
            PushyLogger.e((String)"Failed to convert ReadableMap into JSON string", (Exception)e);
        }
        launchIntent.putExtra("_pushyNotificationClicked", true);
        launchIntent.putExtra("_pushyNotificationPayload", json);
        return PendingIntent.getActivity((Context)context, (int)json.hashCode(), (Intent)launchIntent, (int)0x4000000);
    }

    @ReactMethod
    public void setNotificationIcon(String iconResourceName) {
        PushyPersistence.setNotificationIcon(iconResourceName, (Context)this.getReactApplicationContext());
    }

    private int getNotificationIcon(Context context) {
        String icon = PushyPersistence.getNotificationIcon(context);
        if (icon != null) {
            String packageName;
            Resources resources = context.getResources();
            int iconId = resources.getIdentifier(icon, "drawable", packageName = context.getPackageName());
            if (iconId != 0) {
                return iconId;
            }
            iconId = resources.getIdentifier(icon, "mipmap", packageName);
            if (iconId != 0) {
                return iconId;
            }
        }
        return 17301659;
    }

    void onNotificationClicked(Intent intent) {
        if (!intent.getBooleanExtra("_pushyNotificationClicked", false)) {
            return;
        }
        String payload = intent.getStringExtra("_pushyNotificationPayload");
        if (PushyStringUtils.stringIsNullOrEmpty((String)payload)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(payload);
            WritableMap map = PushyMapUtils.convertJsonToMap(jsonObject);
            ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("NotificationClick", (Object)map);
        }
        catch (Exception e) {
            PushyLogger.e((String)"Failed to parse JSON into WritableMap", (Exception)e);
        }
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
    }

    public void onNewIntent(Intent intent) {
        this.onNotificationClicked(intent);
    }
}

