/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.react.modules;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.RingtoneManager;
import android.os.AsyncTask;
import android.support.v4.app.NotificationCompat;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import me.pushy.sdk.Pushy;
import me.pushy.sdk.util.exceptions.PushyException;

public class PushyModule
extends ReactContextBaseJavaModule {
    public PushyModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "PushyModule";
    }

    @ReactMethod
    public void notify(String title, String text) {
        ReactApplicationContext context = this.getReactApplicationContext();
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)context).setSmallIcon(17301659).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setVibrate(new long[]{0L, 400L, 250L, 400L}).setContentIntent(this.getMainActivityPendingIntent((Context)context)).setSound(RingtoneManager.getDefaultUri((int)2));
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(1, builder.build());
    }

    @ReactMethod
    public void register(final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String deviceToken = Pushy.register((Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)deviceToken);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void listen() {
        Pushy.listen((Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void subscribe(final String topic, final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Pushy.subscribe((String)topic, (Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)true);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void unsubscribe(final String topic, final Promise promise) {
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Pushy.unsubscribe((String)topic, (Context)PushyModule.this.getReactApplicationContext());
                    promise.resolve((Object)true);
                }
                catch (PushyException exc) {
                    promise.reject((Throwable)exc);
                }
            }
        });
    }

    @ReactMethod
    public void togglePermissionVerification(boolean value) {
        Pushy.togglePermissionVerification((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void toggleDirectConnectivity(boolean value) {
        Pushy.toggleDirectConnectivity((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void toggleNotifications(boolean value) {
        Pushy.toggleNotifications((boolean)value, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setHeartbeatInterval(int seconds) {
        Pushy.setHeartbeatInterval((int)seconds, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void setEnterpriseConfig(String apiEndpoint, String mqttEndpoint) {
        Pushy.setEnterpriseConfig((String)apiEndpoint, (String)mqttEndpoint, (Context)this.getReactApplicationContext());
    }

    @ReactMethod
    public void isRegistered(Promise promise) {
        promise.resolve((Object)Pushy.isRegistered((Context)this.getReactApplicationContext()));
    }

    @ReactMethod
    public void getDeviceCredentials(Promise promise) {
        promise.resolve((Object)Pushy.getDeviceCredentials((Context)this.getReactApplicationContext()));
    }

    private PendingIntent getMainActivityPendingIntent(Context context) {
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(context.getApplicationContext().getPackageName());
        launchIntent.addFlags(0x24000000);
        return PendingIntent.getActivity((Context)context, (int)0, (Intent)launchIntent, (int)0x8000000);
    }
}

